/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeEncodingException;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshall.DataValueMarshallHandler;
import oracle.dbtools.raptor.datatypes.objects.BlobDatum;
import oracle.dbtools.raptor.datatypes.objects.LargeBinary;
import oracle.dbtools.raptor.datatypes.oracle.sql.LOB;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.util.encoding.EncodingException;
import org.xml.sax.SAXException;

public class BLOB
extends LOB {
    protected BLOB(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        super(dataTypeContext, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, StringType stringType, int n) {
        LargeBinary largeBinary = (LargeBinary)dataValueInternal.getInternalValue();
        return largeBinary.getStringValue(stringType, n);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, ValueType valueType, Object object) {
        Object object2 = dataValueInternal.getInternalValue();
        BlobDatum blobDatum = (BlobDatum)object2;
        try {
            switch (valueType) {
                case JDBC: 
                case DATUM: 
                case TARGET: {
                    return blobDatum.getTypedValue(dataTypeConnectionProvider, valueType, object);
                }
            }
            return super.customTypedValue(dataTypeConnectionProvider, dataValueInternal, valueType, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataTypeIllegalArgumentException(this, object2, illegalArgumentException);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object2);
        }
        catch (IOException iOException) {
            throw new DataTypeIllegalArgumentException(this, object2);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return InputStream.class;
            }
            case JDBC: 
            case DATUM: {
                return Blob.class;
            }
            case DEFAULT: {
                return BlobDatum.class;
            }
        }
        return super.customTypedClass(dataTypeConnectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2004;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider dataTypeConnectionProvider, Object object) {
        try {
            if (object == null) {
                return new BlobDatum();
            }
            if (object instanceof BlobDatum) {
                return object;
            }
            return BlobDatum.constructFrom(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataTypeIllegalArgumentException(this, object, illegalArgumentException);
        }
        catch (EncodingException encodingException) {
            throw new DataTypeIllegalArgumentException(this, object, encodingException);
        }
        catch (SQLException sQLException) {
            throw new DataTypeIllegalArgumentException(this, object, sQLException);
        }
        catch (IOException iOException) {
            throw new DataTypeIllegalArgumentException(this, object, iOException);
        }
    }

    @Override
    protected void customMarshallToXml(DataTypeConnectionProvider dataTypeConnectionProvider, DataValueInternal dataValueInternal, DataValueMarshallHandler dataValueMarshallHandler, String string) throws SAXException {
        BlobDatum blobDatum = (BlobDatum)dataValueInternal.getInternalValue();
        blobDatum.marshallToXml(this, dataValueMarshallHandler, string);
    }

    @Override
    public Object startDataValue(String string, boolean bl) {
        if (bl) {
            return null;
        }
        return BlobDatum.getBuilder();
    }

    @Override
    public void bodyDataValue(NamedValue namedValue, char[] cArray, int n, int n2) {
        BlobDatum.BlobDatumBuilder blobDatumBuilder = (BlobDatum.BlobDatumBuilder)namedValue.getValue();
        try {
            blobDatumBuilder.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new DataTypeIOException(iOException);
        }
        catch (EncodingException encodingException) {
            throw new DataTypeEncodingException(encodingException);
        }
    }

    @Override
    public DataValue endDataValue(NamedValue namedValue) {
        BlobDatum.BlobDatumBuilder blobDatumBuilder = (BlobDatum.BlobDatumBuilder)namedValue.getValue();
        try {
            return this.getDataValue(blobDatumBuilder != null ? blobDatumBuilder.build() : null);
        }
        catch (IOException iOException) {
            throw new DataTypeIOException(iOException);
        }
    }
}

