/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMP;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTimeZoneUtil;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;

public class OraTIMESTAMPTZ
extends OraTemporalDatum {
    private TimeZone sessionTimeZone;

    public static OraTIMESTAMPTZ getInstance() {
        return OraTIMESTAMPTZ.getInstance(TimeZone.getDefault());
    }

    public static OraTIMESTAMPTZ getInstance(TimeZone timeZone) {
        OraTIMESTAMPTZ oraTIMESTAMPTZ = OraTIMESTAMPTZ.getInstance(Calendar.getInstance(timeZone));
        if (oraTIMESTAMPTZ != null) {
            oraTIMESTAMPTZ.setNow();
        }
        return oraTIMESTAMPTZ;
    }

    public static OraTIMESTAMPTZ getInstance(Calendar calendar, Integer n) {
        return calendar != null ? new OraTIMESTAMPTZ(new OraTIMESTAMPTZImpl(UTC, calendar, n)) : null;
    }

    public static OraTIMESTAMPTZ getInstance(Calendar calendar) {
        return OraTIMESTAMPTZ.getInstance(calendar, null);
    }

    public static OraTIMESTAMPTZ getInstance(TIMESTAMPTZ tIMESTAMPTZ) {
        return tIMESTAMPTZ != null ? new OraTIMESTAMPTZ(new OraTIMESTAMPTZImpl(UTC, (Datum)tIMESTAMPTZ)) : null;
    }

    public static OraTIMESTAMPTZ getInstance(Date date, TimeZone timeZone) {
        return date != null ? new OraTIMESTAMPTZ(new OraTIMESTAMPTZImpl(timeZone, UTC, date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime()))) : null;
    }

    public static OraTIMESTAMPTZ getInstance(Date date) {
        return OraTIMESTAMPTZ.getInstance(date, TimeZone.getDefault());
    }

    protected OraTIMESTAMPTZ(OraTIMESTAMPTZImpl oraTIMESTAMPTZImpl) {
        super(oraTIMESTAMPTZImpl);
    }

    @Override
    public boolean userTimeZoneSupported() {
        return true;
    }

    @Override
    public Object clone() {
        OraTIMESTAMPTZ oraTIMESTAMPTZ = (OraTIMESTAMPTZ)super.clone();
        oraTIMESTAMPTZ.sessionTimeZone = this.sessionTimeZone;
        return oraTIMESTAMPTZ;
    }

    @Override
    public void replicate(OraTemporalDatum oraTemporalDatum) {
        super.replicate(oraTemporalDatum);
        this.setSessionTimeZone(oraTemporalDatum.getSessionTimeZone());
    }

    @Override
    public void setSessionTimeZone(TimeZone timeZone) {
        this.sessionTimeZone = timeZone;
    }

    @Override
    public TimeZone getSessionTimeZone() {
        return this.sessionTimeZone;
    }

    public TIMESTAMPTZ getDatum(TimeZone timeZone) {
        byte[] byArray = new byte[13];
        OraTIMESTAMPTZImpl oraTIMESTAMPTZImpl = (OraTIMESTAMPTZImpl)this.datumImpl.clone();
        oraTIMESTAMPTZImpl.setTimeZone(UTC);
        oraTIMESTAMPTZImpl.packDatumBytes(byArray, timeZone);
        return new TIMESTAMPTZ(byArray);
    }

    public TIMESTAMPTZ getDatum() {
        return this.getDatum(this.getTimeZone());
    }

    public String toString() {
        try {
            OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = new OraTIMESTAMPTZFormat(new OracleNLSProvider(null).getTimeStampWithTimeZoneFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US));
            return oraTIMESTAMPTZFormat.format(this.getDatum());
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    protected static class OraTIMESTAMPTZImpl
    extends OraTIMESTAMP.OraTIMESTAMPImpl {
        private static final int REGIONIDBIT = 128;
        private static final byte OFFSET_HOUR = 20;
        private static final byte OFFSET_MINUTE = 60;
        private static final String[] digit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

        protected OraTIMESTAMPTZImpl(TimeZone timeZone, Calendar calendar, Integer n) {
            super(timeZone, calendar, n);
            this.setTimeZone(calendar.getTimeZone());
        }

        protected OraTIMESTAMPTZImpl(TimeZone timeZone, Datum datum) {
            super(timeZone, datum);
        }

        protected OraTIMESTAMPTZImpl(TimeZone timeZone, TimeZone timeZone2, Timestamp timestamp) {
            super(timeZone2, timestamp);
            this.setTimeZone(timeZone);
        }

        @Override
        protected int getDatumLength(int n) {
            return 13;
        }

        @Override
        protected boolean isDatumLengthValid(int n) {
            return n == 13;
        }

        @Override
        protected void unpackDatumBytes(byte[] byArray) {
            super.unpackDatumBytes(byArray);
            String string = OraTIMESTAMPTZImpl.unpackTimeZoneID(byArray);
            if (string != null) {
                this.setTimeZone(TimeZone.getTimeZone(string));
            }
        }

        protected static String unpackTimeZoneID(byte[] byArray) {
            boolean bl;
            if (byArray.length < 13) {
                return null;
            }
            if ((byArray[11] & 0x80) != 0) {
                int n = ((byArray[11] & 0x7F) << 6) + ((byArray[12] & 0xFC) >> 2);
                return OraTimeZoneUtil.getInstance().getRegion(n);
            }
            int n = byArray[11] - 20;
            int n2 = byArray[12] - 60;
            boolean bl2 = bl = n < 0 || n2 < 0;
            if (bl) {
                n = -n;
                n2 = -n2;
            }
            return "GMT" + (bl ? "-" : "+") + digit[n / 10] + digit[n % 10] + ":" + digit[n2 / 10] + digit[n2 % 10];
        }

        protected void packDatumBytes(byte[] byArray, TimeZone timeZone) {
            super.packDatumBytes(byArray);
            OraTIMESTAMPTZImpl.packTimeZoneID(byArray, this.getTimeInMillis(), timeZone);
        }

        protected static void packTimeZoneID(byte[] byArray, long l, TimeZone timeZone) {
            int n = OraTimeZoneUtil.getInstance().getID(timeZone.getID());
            if (n > 0) {
                OraTIMESTAMPTZImpl.packTZRegion(byArray, n);
            } else {
                OraTIMESTAMPTZImpl.packTZOffset(byArray, timeZone, l);
            }
        }

        private static void packTZRegion(byte[] byArray, int n) {
            byArray[11] = (byte)((n & 0x1FC0) >> 6 | 0x80);
            byArray[12] = (byte)((n & 0x3F) << 2);
        }

        private static void packTZOffset(byte[] byArray, TimeZone timeZone, long l) {
            int n = timeZone.getOffset(l) / 60000;
            byArray[11] = (byte)(n / 60 + 20);
            byArray[12] = (byte)(n % 60 + 60);
        }
    }
}

