/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraConversions;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

public class OraTIMESTAMP
extends OraTemporalDatum {
    public static OraTIMESTAMP getInstance() {
        OraTIMESTAMP oraTIMESTAMP = OraTIMESTAMP.getInstance(Calendar.getInstance());
        if (oraTIMESTAMP != null) {
            oraTIMESTAMP.setNow();
        }
        return oraTIMESTAMP;
    }

    public static OraTIMESTAMP getInstance(Calendar calendar, Integer n) {
        return calendar != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(UTC, calendar, n)) : null;
    }

    public static OraTIMESTAMP getInstance(Calendar calendar) {
        return OraTIMESTAMP.getInstance(calendar, null);
    }

    public static OraTIMESTAMP getInstance(TIMESTAMP tIMESTAMP) {
        return tIMESTAMP != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(UTC, (Datum)tIMESTAMP)) : null;
    }

    public static OraTIMESTAMP getInstance(Date date) {
        return date != null ? new OraTIMESTAMP(new OraTIMESTAMPImpl(UTC, date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime()))) : null;
    }

    protected OraTIMESTAMP(OraTIMESTAMPImpl oraTIMESTAMPImpl) {
        super(oraTIMESTAMPImpl);
    }

    @Override
    public boolean timeZoneOverlayed() {
        return true;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.datumImpl.overlayTimeZone(timeZone);
    }

    @Override
    public void setSessionTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            this.setTimeZone(UTC);
            this.sessionTimeZoneAdjusted = false;
        } else {
            this.setTimeZone(timeZone);
            this.sessionTimeZoneAdjusted = true;
        }
    }

    public TIMESTAMP getDatum() {
        byte[] byArray = new byte[this.datumImpl.getNanos() > 0 ? 11 : 7];
        this.datumImpl.packDatumBytes(byArray);
        return new TIMESTAMP(byArray);
    }

    public String toString() {
        try {
            OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(new OracleNLSProvider(null).getTimeStampFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US));
            return oraTIMESTAMPFormat.format(this.getDatum());
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    protected static class OraTIMESTAMPImpl
    extends OraTemporalDatum.OraTemporalDatumImpl {
        protected OraTIMESTAMPImpl(TimeZone timeZone, Calendar calendar, Integer n) {
            super(timeZone, calendar, n);
        }

        protected OraTIMESTAMPImpl(TimeZone timeZone, Datum datum) {
            super(timeZone, datum);
        }

        protected OraTIMESTAMPImpl(TimeZone timeZone, Timestamp timestamp) {
            super(timeZone, timestamp);
        }

        @Override
        protected int getDatumLength(int n) {
            return n > 0 ? 11 : 7;
        }

        @Override
        protected boolean isDatumLengthValid(int n) {
            return n == 11 || n == 7;
        }

        @Override
        protected void unpackDatumBytes(byte[] byArray) {
            super.unpackDatumBytes(byArray);
            if (byArray.length > 7) {
                this.setNanos(OraTIMESTAMPImpl.unpackNanos(byArray));
            }
        }

        @Override
        protected void packDatumBytes(byte[] byArray) {
            super.packDatumBytes(byArray);
            int n = this.getNanos();
            if (n > 0 || byArray.length > 7) {
                OraTIMESTAMPImpl.packNanos(byArray, n);
            }
        }

        private static int unpackNanos(byte[] byArray) {
            return OraConversions.convertNanos(byArray);
        }

        private static void packNanos(byte[] byArray, int n) {
            byArray[7] = (byte)(n >> 24 & 0xFF);
            byArray[8] = (byte)(n >> 16 & 0xFF);
            byArray[9] = (byte)(n >> 8 & 0xFF);
            byArray[10] = (byte)(n & 0xFF);
        }
    }
}

