/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.raptor.datatypes.objects.OraIntervalDatum;
import oracle.dbtools.raptor.nls.OraINTERVALYMFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.INTERVALYM;

public class OraINTERVALYM
extends OraIntervalDatum {
    public static final int SIZE_INTERVALYM = 5;
    public static final int BYTE_YEAR1 = 0;
    public static final int BYTE_YEAR2 = 1;
    public static final int BYTE_YEAR3 = 2;
    public static final int BYTE_YEAR4 = 3;
    public static final int BYTE_MONTH = 4;
    private static final int INTERVALBYTEOFFSET = 60;
    private static final int INTERVALWORDOFFSET = Integer.MIN_VALUE;

    public static OraINTERVALYM getInstance() {
        return OraINTERVALYM.getInstance(0, 0);
    }

    public static OraINTERVALYM getInstance(int n, int n2) {
        return new OraINTERVALYM(new OraINTERVALYMImpl(n, n2));
    }

    public static OraINTERVALYM getInstance(INTERVALYM iNTERVALYM) {
        return iNTERVALYM != null ? new OraINTERVALYM(new OraINTERVALYMImpl(iNTERVALYM)) : null;
    }

    protected OraINTERVALYM(OraINTERVALYMImpl oraINTERVALYMImpl) {
        super(oraINTERVALYMImpl);
    }

    @Override
    public boolean nanosSupported() {
        return false;
    }

    public INTERVALYM getDatum() {
        byte[] byArray = ((OraINTERVALYMImpl)this.datumImpl).getDatumBytes();
        return new INTERVALYM(byArray);
    }

    public String toString() {
        try {
            OraINTERVALYMFormat oraINTERVALYMFormat = new OraINTERVALYMFormat(OraLocaleInfo.getInstance((Locale)Locale.US));
            return oraINTERVALYMFormat.format(this.getDatum());
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    protected static class OraINTERVALYMImpl
    extends OraIntervalDatum.OraIntervalDatumImpl {
        protected OraINTERVALYMImpl(int n, int n2) {
            super(new YMMetadata(), OraINTERVALYMImpl.getFieldArray(n, n2), 1, 2, 2, 9);
        }

        protected OraINTERVALYMImpl(INTERVALYM iNTERVALYM) {
            super(new YMMetadata(), OraINTERVALYMImpl.getFieldArray(iNTERVALYM.shareBytes()), 1, 2, 2, 9);
        }

        protected static int[] getFieldArray(int n, int n2) {
            int[] nArray = new int[]{0, n, n2};
            return nArray;
        }

        protected static int[] getFieldArray(byte[] byArray) {
            int n = 0;
            int n2 = (byArray[0] & 0xFF) << 24;
            n2 |= (byArray[1] & 0xFF) << 16;
            n2 |= (byArray[2] & 0xFF) << 8;
            n2 |= byArray[3] & 0xFF;
            n = byArray[4] - 60;
            return OraINTERVALYMImpl.getFieldArray(n2 -= Integer.MIN_VALUE, n);
        }

        @Override
        protected byte[] getDatumBytes() {
            byte[] byArray = new byte[5];
            int n = this.get(0);
            int n2 = this.get(1) * n + Integer.MIN_VALUE;
            int n3 = this.get(2) * n + 60;
            byArray[0] = (byte)(n2 >> 24 & 0xFF);
            byArray[1] = (byte)(n2 >> 16 & 0xFF);
            byArray[2] = (byte)(n2 >> 8 & 0xFF);
            byArray[3] = (byte)(n2 & 0xFF);
            byArray[4] = (byte)(n3 & 0xFF);
            return byArray;
        }

        @Override
        public void normalize() {
            int n = this.get(1);
            int n2 = this.get(2);
            int n3 = n2 % 12;
            if (n3 != 0) {
                n += n3;
                n2 -= n3 * 12;
            }
            this.set(2, n2);
            this.set(1, n);
        }

        protected static class YMMetadata
        extends OraIntervalDatum.MetaData {
            private ArrayList<OraIntervalDatum.Field> fieldMetaData = new ArrayList(3);

            private YMMetadata() {
                this.fieldMetaData.add(OraIntervalDatum.Field.SIGN);
                this.fieldMetaData.add(OraIntervalDatum.Field.YEARS);
                this.fieldMetaData.add(OraIntervalDatum.Field.MONTHS);
            }

            @Override
            protected List<OraIntervalDatum.Field> getFieldList() {
                return this.fieldMetaData;
            }

            @Override
            public Object clone() {
                YMMetadata yMMetadata = (YMMetadata)super.clone();
                yMMetadata.fieldMetaData = (ArrayList)this.fieldMetaData.clone();
                return yMMetadata;
            }
        }
    }
}

