/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.raptor.datatypes.objects.OraIntervalDatum;
import oracle.dbtools.raptor.nls.OraINTERVALDSFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.INTERVALDS;

public class OraINTERVALDS
extends OraIntervalDatum {
    public static final int SIZE_INTERVALDS = 11;
    public static final int BYTE_DAY1 = 0;
    public static final int BYTE_DAY2 = 1;
    public static final int BYTE_DAY3 = 2;
    public static final int BYTE_DAY4 = 3;
    public static final int BYTE_HOUR = 4;
    public static final int BYTE_MINUTE = 5;
    public static final int BYTE_SECOND = 6;
    public static final int BYTE_NANOS1 = 7;
    public static final int BYTE_NANOS2 = 8;
    public static final int BYTE_NANOS3 = 9;
    public static final int BYTE_NANOS4 = 10;
    private static final int INTERVALBYTEOFFSET = 60;
    private static final int INTERVALWORDOFFSET = Integer.MIN_VALUE;

    public static OraINTERVALDS getInstance() {
        return OraINTERVALDS.getInstance(0, 0, 0, 0, 0);
    }

    public static OraINTERVALDS getInstance(int n, int n2, int n3, int n4, int n5) {
        return new OraINTERVALDS(new OraINTERVALDSImpl(n, n2, n3, n4, n5));
    }

    public static OraINTERVALDS getInstance(INTERVALDS iNTERVALDS) {
        return iNTERVALDS != null ? new OraINTERVALDS(new OraINTERVALDSImpl(iNTERVALDS)) : null;
    }

    protected OraINTERVALDS(OraINTERVALDSImpl oraINTERVALDSImpl) {
        super(oraINTERVALDSImpl);
    }

    @Override
    public boolean nanosSupported() {
        return true;
    }

    public INTERVALDS getDatum() {
        byte[] byArray = ((OraINTERVALDSImpl)this.datumImpl).getDatumBytes();
        return new INTERVALDS(byArray);
    }

    public String toString() {
        try {
            OraINTERVALDSFormat oraINTERVALDSFormat = new OraINTERVALDSFormat(OraLocaleInfo.getInstance((Locale)Locale.US));
            return oraINTERVALDSFormat.format(this.getDatum());
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    protected static class OraINTERVALDSImpl
    extends OraIntervalDatum.OraIntervalDatumImpl {
        protected OraINTERVALDSImpl(int n, int n2, int n3, int n4, int n5) {
            super(new DSMetadata(), OraINTERVALDSImpl.getFieldArray(n, n2, n3, n4, n5), 1, 2, 4, 9);
        }

        protected OraINTERVALDSImpl(INTERVALDS iNTERVALDS) {
            super(new DSMetadata(), OraINTERVALDSImpl.getFieldArray(iNTERVALDS.shareBytes()), 1, 2, 4, 9);
        }

        protected static int[] getFieldArray(int n, int n2, int n3, int n4, int n5) {
            int[] nArray = new int[]{0, n, n2, n3, n4, n5};
            return nArray;
        }

        protected static int[] getFieldArray(byte[] byArray) {
            int n = 0;
            int n2 = (byArray[0] & 0xFF) << 24;
            n2 |= (byArray[1] & 0xFF) << 16;
            n2 |= (byArray[2] & 0xFF) << 8;
            n2 |= byArray[3] & 0xFF;
            n2 -= Integer.MIN_VALUE;
            int n3 = byArray[4] - 60;
            int n4 = byArray[5] - 60;
            int n5 = byArray[6] - 60;
            n = (byArray[7] & 0xFF) << 24;
            n |= (byArray[8] & 0xFF) << 16;
            n |= (byArray[9] & 0xFF) << 8;
            n |= byArray[10] & 0xFF;
            return OraINTERVALDSImpl.getFieldArray(n2, n3, n4, n5, n -= Integer.MIN_VALUE);
        }

        @Override
        protected byte[] getDatumBytes() {
            byte[] byArray = new byte[11];
            int n = this.get(0);
            int n2 = this.get(1) * n + Integer.MIN_VALUE;
            int n3 = this.get(2) * n + 60;
            int n4 = this.get(3) * n + 60;
            int n5 = this.get(4) * n + 60;
            int n6 = this.get(5) * n + Integer.MIN_VALUE;
            byArray[0] = (byte)(n2 >> 24 & 0xFF);
            byArray[1] = (byte)(n2 >> 16 & 0xFF);
            byArray[2] = (byte)(n2 >> 8 & 0xFF);
            byArray[3] = (byte)(n2 & 0xFF);
            byArray[4] = (byte)n3;
            byArray[5] = (byte)n4;
            byArray[6] = (byte)(n5 & 0xFF);
            byArray[7] = (byte)(n6 >> 24 & 0xFF);
            byArray[8] = (byte)(n6 >> 16 & 0xFF);
            byArray[9] = (byte)(n6 >> 8 & 0xFF);
            byArray[10] = (byte)(n6 & 0xFF);
            return byArray;
        }

        @Override
        public void normalize() {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this.get(1);
            int n6 = this.get(2);
            int n7 = this.get(3);
            int n8 = this.get(4);
            int n9 = this.get(5);
            double d = (double)n9 * 1.0 / (double)(n4 = (int)Math.pow(10.0, 9 - this.getFractionalPrecision()));
            long l = Math.round(d);
            int n10 = (int)(l * (long)n4);
            int n11 = n10 % 999999999;
            if (n11 != 0) {
                n8 += n11;
                n9 -= n11 * 999999999;
            }
            if ((n3 = n8 % 60) != 0) {
                n7 += n3;
                n8 -= n3 * 60;
            }
            if ((n2 = n7 % 60) != 0) {
                n6 += n2;
                n7 -= n2 * 60;
            }
            if ((n = n6 % 24) != 0) {
                n5 += n;
                n6 -= n * 24;
            }
            this.set(5, n9);
            this.set(4, n8);
            this.set(3, n7);
            this.set(2, n6);
            this.set(1, n5);
        }

        protected static class DSMetadata
        extends OraIntervalDatum.MetaData {
            private ArrayList<OraIntervalDatum.Field> fieldMetaData = new ArrayList(6);

            private DSMetadata() {
                this.fieldMetaData.add(OraIntervalDatum.Field.SIGN);
                this.fieldMetaData.add(OraIntervalDatum.Field.DAYS);
                this.fieldMetaData.add(OraIntervalDatum.Field.HOURS);
                this.fieldMetaData.add(OraIntervalDatum.Field.MINUTES);
                this.fieldMetaData.add(OraIntervalDatum.Field.SECONDS);
                this.fieldMetaData.add(OraIntervalDatum.Field.NANOS);
            }

            @Override
            protected List<OraIntervalDatum.Field> getFieldList() {
                return this.fieldMetaData;
            }

            @Override
            public Object clone() {
                DSMetadata dSMetadata = (DSMetadata)super.clone();
                dSMetadata.fieldMetaData = (ArrayList)this.fieldMetaData.clone();
                return dSMetadata;
            }
        }
    }
}

