/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.ClobDatum;
import oracle.dbtools.raptor.datatypes.objects.LongBinary;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.jdbc.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.Datum;

public class BlobDatum
extends LongBinary {
    public BlobDatum() {
    }

    protected BlobDatum(BlobDatum blobDatum) {
        super(blobDatum);
    }

    protected BlobDatum(Object object) {
        super(object);
    }

    public BlobDatum(Blob blob) throws SQLException {
        super(blob);
    }

    public BlobDatum(byte[] byArray) {
        super(byArray);
    }

    public BlobDatum(File file) {
        super(file);
    }

    public BlobDatum(InputStream inputStream) throws IOException {
        this(inputStream, 32768);
    }

    public BlobDatum(InputStream inputStream, int n) throws IOException {
        this(BlobDatum.getBuilder(EncodingType.ENCODING_NONE, n).write(inputStream).build());
    }

    public BlobDatum(CharSequence charSequence) throws IOException, EncodingException {
        this(charSequence, 32768);
    }

    public BlobDatum(CharSequence charSequence, int n) throws IOException, EncodingException {
        this(BlobDatum.getBuilder(EncodingType.ENCODING_HEX, n).write(new StringReader(charSequence.toString())).build());
    }

    public BlobDatum(char[] cArray) throws IOException, EncodingException {
        this(cArray, 32768);
    }

    public BlobDatum(char[] cArray, int n) throws IOException, EncodingException {
        this(BlobDatum.getBuilder(EncodingType.ENCODING_HEX, n).write(new CharArrayReader(cArray)).build());
    }

    public BlobDatum(Reader reader) throws IOException, EncodingException {
        this(reader, 32768);
    }

    public BlobDatum(Reader reader, int n) throws IOException, EncodingException {
        this(BlobDatum.getBuilder(EncodingType.ENCODING_HEX, n).write(reader).build());
    }

    public static BlobDatum constructFrom(Object object) throws IOException, SQLException, EncodingException {
        if (object instanceof Blob) {
            return new BlobDatum((Blob)object);
        }
        if (object instanceof byte[]) {
            return new BlobDatum((byte[])object);
        }
        if (object instanceof InputStream) {
            return new BlobDatum((InputStream)object);
        }
        if (object instanceof char[]) {
            return new BlobDatum(String.valueOf((char[])object));
        }
        if (object instanceof CharSequence) {
            return new BlobDatum((CharSequence)object);
        }
        if (object instanceof File) {
            return new BlobDatum((File)object);
        }
        if (object instanceof Reader) {
            return new BlobDatum((Reader)object);
        }
        if (object instanceof Datum) {
            Datum datum = (Datum)object;
            return new BlobDatum(datum.stringValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long getLength() throws SQLException {
        if (this.getValue() instanceof Blob) {
            Blob blob = (Blob)this.getValue();
            if (BlobDatum.isEmptyLob(blob)) {
                return 0L;
            }
            return ((Blob)this.getValue()).length();
        }
        return super.getLength();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof BlobDatum) {
            bl = super.equals(object);
        }
        return bl;
    }

    @Override
    public InputStream getInputStream() throws IOException, SQLException {
        if (this.getValue() instanceof Blob) {
            Blob blob = (Blob)this.getValue();
            if (BlobDatum.isEmptyLob(blob)) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return blob.getBinaryStream();
        }
        return super.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType, Object object) throws IOException, SQLException {
        Object object2 = this.getValue();
        switch (valueType) {
            case DATUM: {
                if (object2 instanceof Blob) {
                    return object2;
                }
                Blob blob = BlobDatum.getTemporaryBlob(dataTypeConnectionProvider.getValidDataTypeConnection());
                BlobDatum.open(blob, 1);
                try {
                    OutputStream outputStream = blob.setBinaryStream(1L);
                    BlobDatum.copyBytes(this.getInputStream(), outputStream);
                    outputStream.close();
                }
                finally {
                    try {
                        BlobDatum.close(blob);
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(ClobDatum.class.getName()).log(Level.WARNING, sQLException.getLocalizedMessage(), sQLException);
                    }
                }
                return blob;
            }
        }
        return super.customTypedValue(dataTypeConnectionProvider, valueType, object);
    }

    public static BlobDatumBuilder getBuilder() {
        return BlobDatum.getBuilder(32768);
    }

    public static BlobDatumBuilder getBuilder(EncodingType encodingType, int n) {
        return new BlobDatum().getBuilder0(encodingType, n);
    }

    public static BlobDatumBuilder getBuilder(EncodingType encodingType) {
        return BlobDatum.getBuilder(encodingType, 32768);
    }

    public static BlobDatumBuilder getBuilder(int n) {
        return new BlobDatum().getBuilder0(EncodingType.ENCODING_BASE64, n);
    }

    private BlobDatumBuilder getBuilder0(EncodingType encodingType, int n) {
        return new BlobDatumBuilder(encodingType, n);
    }

    protected static Blob getTemporaryBlob(Connection connection) throws SQLException {
        if (connection instanceof OracleConnection) {
            return BLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
        }
        return connection.createBlob();
    }

    protected static Blob getEmptyBlob(Connection connection) throws SQLException {
        if (connection instanceof OracleConnection) {
            return BLOB.getEmptyBLOB();
        }
        return BlobDatum.getTemporaryBlob(connection);
    }

    protected static boolean isEmptyLob(Blob blob) throws SQLException {
        if (blob instanceof BLOB) {
            return ((BLOB)blob).isEmptyLob();
        }
        return false;
    }

    protected static void open(Blob blob, int n) throws SQLException {
        BLOB bLOB;
        if (blob instanceof BLOB && !(bLOB = (BLOB)blob).isEmptyLob() && !bLOB.isOpen()) {
            bLOB.open(n);
        }
    }

    protected static void close(Blob blob) throws SQLException {
        BLOB bLOB;
        if (blob instanceof BLOB && !(bLOB = (BLOB)blob).isEmptyLob() && bLOB.isOpen()) {
            bLOB.close();
        }
    }

    protected static void free(Blob blob) throws SQLException {
        BLOB bLOB;
        if (blob instanceof BLOB && (bLOB = (BLOB)blob).isTemporary() && !bLOB.isOpen()) {
            bLOB.freeTemporary();
        }
        blob.free();
    }

    public class BlobDatumBuilder
    extends LongBinary.LongBinaryBuilder {
        protected BlobDatumBuilder(EncodingType encodingType, int n) {
            super(BlobDatum.this, encodingType, n);
        }

        @Override
        public BlobDatumBuilder write(Reader reader) throws IOException, EncodingException {
            return (BlobDatumBuilder)super.write(reader);
        }

        @Override
        public BlobDatumBuilder write(InputStream inputStream) throws IOException {
            return (BlobDatumBuilder)super.write(inputStream);
        }

        @Override
        public BlobDatum build() throws IOException {
            super.build();
            return BlobDatum.this;
        }
    }
}

