/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;

public class BindContextImpl
implements BindContext {
    private int lastBindIndex;
    private List<String> bindTokens;
    protected final DataTypeConnectionProvider connectionProvider;

    public BindContextImpl(DataTypeConnectionProvider dataTypeConnectionProvider) {
        this.connectionProvider = dataTypeConnectionProvider;
        this.lastBindIndex = 0;
        this.bindTokens = null;
    }

    @Override
    public String nextBindToken() {
        return ":" + ++this.lastBindIndex;
    }

    @Override
    public String lastBindToken() {
        return ":" + this.lastBindIndex;
    }

    @Override
    public int remapPosition(String string) {
        int n = -1;
        if (this.bindTokens != null && (n = this.bindTokens.indexOf(string)) >= 0) {
            ++n;
        }
        return n;
    }

    @Override
    public void setBindTokens(List<String> list) {
        this.bindTokens = list;
    }

    @Override
    public List<String> getBindTokens() {
        return this.bindTokens;
    }

    @Override
    public DataTypeConnectionProvider getDataTypeConnectionProvider() {
        return this.connectionProvider;
    }
}

