/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;

public abstract class RaptorTaskAdapter
implements IRaptorTaskListener {
    public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
    }

    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
    }

    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
    }

    public void taskPaused(RaptorTaskEvent raptorTaskEvent) {
    }

    public void taskRunning(RaptorTaskEvent raptorTaskEvent) {
    }

    public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
    }

    @Override
    public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    @Override
    public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    @Override
    public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
        switch (raptorTaskEvent.getTaskDescriptor().getStatus()) {
            case PAUSED: {
                this.taskPaused(raptorTaskEvent);
                break;
            }
            case RUNNABLE: {
                this.taskRunning(raptorTaskEvent);
                break;
            }
            case FINISHED: {
                if (raptorTaskEvent.getTaskDescriptor().isCancelled()) {
                    this.taskCancelled(raptorTaskEvent);
                    break;
                }
                this.taskFinished(raptorTaskEvent);
                break;
            }
            case NEW: {
                this.taskScheduled(raptorTaskEvent);
                break;
            }
            case FAILED: {
                if (raptorTaskEvent.getTaskDescriptor().isCancelled()) {
                    this.taskCancelled(raptorTaskEvent);
                    break;
                }
                this.taskFailed(raptorTaskEvent);
                break;
            }
            default: {
                throw new IllegalStateException(Messages.getString("RaptorTaskDescriptor.0") + (Object)((Object)raptorTaskEvent.getTaskDescriptor().getStatus()));
            }
        }
    }
}

