/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.TaskException;

public abstract class RaptorTask<V>
implements Callable<V> {
    private boolean _isPausable = false;
    private boolean _isCancelable = true;
    private IRaptorTaskStatus _requestedStatus = null;
    private Object _pauseLock = new Object();
    private RaptorTaskDescriptor _raptorTaskDescriptor;
    private Future<V> _future = null;
    private IRaptorTaskProgressUpdater _updater = new TaskProgressUpdater();

    public RaptorTask(String string) {
        this._raptorTaskDescriptor = new RaptorTaskDescriptor(string);
    }

    public RaptorTask(String string, boolean bl) {
        this._raptorTaskDescriptor = new RaptorTaskDescriptor(string, bl);
    }

    public RaptorTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode) {
        this._raptorTaskDescriptor = new RaptorTaskDescriptor(string, bl, iRaptorTaskRunMode);
    }

    public String toString() {
        return this._raptorTaskDescriptor.getName() + "_" + this.hashCode();
    }

    public final boolean requestCancel() {
        if (!this.isCancellable()) {
            return false;
        }
        this._requestedStatus = IRaptorTaskStatus.FINISHED;
        this.setMessage(Messages.getString("RaptorTask.3"));
        boolean bl = this.cancel();
        if (bl) {
            this.setMessage(Messages.getString("RaptorTask.0"));
        } else {
            this.setMessage(Messages.getString("RaptorTask.5"));
        }
        return bl;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isCancellable() {
        return this._isCancelable;
    }

    public void setCancellable(boolean bl) {
        this._isCancelable = bl;
    }

    protected boolean isPausable() {
        return this._isPausable;
    }

    public void setPausable(boolean bl) {
        this._isPausable = bl;
    }

    public final void requestPause() {
        if (!this.isPausable()) {
            return;
        }
        this._requestedStatus = IRaptorTaskStatus.PAUSED;
        this.setMessage(Messages.getString("RaptorTask.6"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V call() throws Exception {
        this.setStatus(IRaptorTaskStatus.RUNNABLE);
        V v = null;
        try {
            v = this.doWork();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.tearDown();
        }
        RaptorTask raptorTask = this;
        synchronized (raptorTask) {
            this.notify();
        }
        return v;
    }

    protected void tearDown() {
    }

    protected abstract V doWork() throws TaskException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this._pauseLock;
        synchronized (object) {
            this._requestedStatus = IRaptorTaskStatus.RUNNABLE;
            this._pauseLock.notify();
        }
    }

    public final IRaptorTaskStatus getStatus() {
        return this._raptorTaskDescriptor.getStatus();
    }

    public final RaptorTaskDescriptor getDescriptor() {
        return this._raptorTaskDescriptor;
    }

    void setStatus(IRaptorTaskStatus iRaptorTaskStatus) {
        this.getDescriptor().setStatus(iRaptorTaskStatus);
    }

    public void setMessage(String string) {
        this.getDescriptor().setMessage(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause() {
        Object object = this._pauseLock;
        synchronized (object) {
            try {
                this._raptorTaskDescriptor.setStatus(IRaptorTaskStatus.PAUSED);
                String string = this.getDescriptor().getMessage();
                this.setMessage(Messages.getString("RaptorTask.8"));
                this._pauseLock.wait();
                this.setMessage(string);
                this._raptorTaskDescriptor.setStatus(IRaptorTaskStatus.RUNNABLE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void checkCanProceed() throws ExecutionException {
        if (this._requestedStatus != null && this._requestedStatus != this._raptorTaskDescriptor.getStatus()) {
            switch (this._requestedStatus) {
                case PAUSED: {
                    this.pause();
                    break;
                }
                case FINISHED: {
                    this.getDescriptor().setCancelled(true);
                    throw new ExecutionException(new CancellationException(Messages.getString("RaptorTask.0")));
                }
            }
        }
    }

    void setFuture(Future<V> future) {
        this._future = future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getResult() throws InterruptedException, ExecutionException {
        while (this._future == null && this.getStatus() == IRaptorTaskStatus.NEW) {
            RaptorTask raptorTask = this;
            synchronized (raptorTask) {
                this.wait(1000L);
            }
        }
        if (this._future == null) {
            throw new ExecutionException(Messages.getString("RaptorTask.10"), new NullPointerException());
        }
        try {
            return this._future.get();
        }
        catch (CancellationException cancellationException) {
            throw new ExecutionException(cancellationException);
        }
    }

    public ISchedulingRule getSchedulingRule() {
        return null;
    }

    public IRaptorTaskProgressUpdater getRaptorTaskProgressUpdater() {
        return this._updater;
    }

    protected boolean mayInterrupt() {
        return true;
    }

    private final class TaskProgressUpdater
    implements IRaptorTaskProgressUpdater {
        private TaskProgressUpdater() {
        }

        @Override
        public void checkCanProceed() throws ExecutionException {
            RaptorTask.this.checkCanProceed();
        }

        @Override
        public RaptorTaskDescriptor getDescriptor() {
            return RaptorTask.this.getDescriptor();
        }

        @Override
        public boolean isCancellable() {
            return RaptorTask.this.isCancellable();
        }

        @Override
        public boolean isPausable() {
            return RaptorTask.this.isPausable();
        }
    }
}

