/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.util.Logger;

public class RaptorMultiTask<T extends RaptorTask<?>>
extends RaptorTask<Void> {
    private BlockingQueue<T> _queue = new LinkedBlockingQueue<T>();
    private Map<RaptorTaskDescriptor, T> _active = Collections.synchronizedMap(new HashMap());
    private List<T> _cancelled = Collections.synchronizedList(new ArrayList());
    private List<T> _failed = Collections.synchronizedList(new ArrayList());
    private List<T> _finished = Collections.synchronizedList(new ArrayList());
    private AtomicInteger _parallelism = new AtomicInteger(4);
    private AtomicInteger _taskCount = new AtomicInteger(0);
    private IRaptorTaskListener _taskListener = new RaptorMultiTaskAdapter();

    public RaptorMultiTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode) {
        super(string, false, iRaptorTaskRunMode);
    }

    public RaptorMultiTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode) {
        super(string, bl, iRaptorTaskRunMode);
    }

    public void addTasks(Collection<T> collection) {
        for (RaptorTask raptorTask : collection) {
            raptorTask.getDescriptor().addListener(this._taskListener);
            this._queue.add(raptorTask);
            this._taskCount.incrementAndGet();
        }
    }

    public void addTask(T t) {
        this.addTasks(Collections.singleton(t));
    }

    public void setParallelism(int n) {
        this._parallelism.set(n);
    }

    public int getParallelism() {
        return this._parallelism.get();
    }

    public List<T> getCancelledTasks() {
        return this._cancelled;
    }

    public List<T> getFailedTasks() {
        return this._failed;
    }

    public List<T> getFinishedTasks() {
        return this._finished;
    }

    @Override
    protected Void doWork() throws TaskException {
        try {
            while (!this.isFinished()) {
                this.checkCanProceed();
                this.processQueue();
                Thread.sleep(250L);
            }
        }
        catch (Throwable throwable) {
            Logger.severe(this.getClass(), this.getDescriptor().getName(), throwable);
            throw new TaskException(throwable);
        }
        if (!this.getFailedTasks().isEmpty()) {
            RaptorTask raptorTask = (RaptorTask)this.getFailedTasks().get(0);
            Throwable throwable = raptorTask.getDescriptor().getThrowable();
            String string = "Child task(s) failed. ";
            if (throwable != null) {
                throw new TaskException(string + throwable.getMessage(), throwable);
            }
            throw new TaskException(string);
        }
        return null;
    }

    @Override
    public boolean cancel() {
        boolean bl = true;
        for (RaptorTask raptorTask : this._active.values()) {
            if (raptorTask.requestCancel()) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    protected void pause() {
        this.pauseActiveTasks();
        super.pause();
        this.resumeActiveTasks();
    }

    private void pauseActiveTasks() {
        for (RaptorTask raptorTask : this._active.values()) {
            raptorTask.requestPause();
        }
    }

    private void resumeActiveTasks() {
        for (RaptorTask raptorTask : this._active.values()) {
            raptorTask.resume();
        }
    }

    private boolean isFinished() {
        return this._queue.isEmpty() && this._active.isEmpty() && this._taskCount.get() == this._cancelled.size() + this._failed.size() + this._finished.size();
    }

    private void processQueue() {
        RaptorTask raptorTask;
        if (this._active.size() <= this.getParallelism() && (raptorTask = (RaptorTask)this._queue.poll()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RaptorTaskManager.getInstance().addTask(raptorTask);
                }
            });
            this._active.put(raptorTask.getDescriptor(), raptorTask);
        }
    }

    private void setProgress() {
        double d = 100.0 * (1.0 - (double)(this._active.size() + this._queue.size()) / (double)this._taskCount.get());
        this.getDescriptor().setProgress((int)d);
    }

    class RaptorMultiTaskAdapter
    extends RaptorTaskAdapter {
        RaptorMultiTaskAdapter() {
        }

        @Override
        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            RaptorTask raptorTask = (RaptorTask)RaptorMultiTask.this._active.remove(raptorTaskEvent.getTaskDescriptor());
            if (raptorTask != null) {
                RaptorMultiTask.this._cancelled.add(raptorTask);
            }
            RaptorMultiTask.this.setProgress();
        }

        @Override
        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            RaptorTask raptorTask = (RaptorTask)RaptorMultiTask.this._active.remove(raptorTaskEvent.getTaskDescriptor());
            if (raptorTask != null) {
                RaptorMultiTask.this._failed.add(raptorTask);
            }
            RaptorMultiTask.this.setProgress();
        }

        @Override
        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            RaptorTask raptorTask = (RaptorTask)RaptorMultiTask.this._active.remove(raptorTaskEvent.getTaskDescriptor());
            if (raptorTask != null) {
                RaptorMultiTask.this._finished.add(raptorTask);
            }
            RaptorMultiTask.this.setProgress();
        }
    }
}

