/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Scrollable;
import javax.swing.text.html.HTMLEditorKit;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.util.Service;

public class Visual
implements ActionListener {
    public long[][] visited = null;
    List<LexerToken> src;
    Parser par;
    private int zoom = 1;
    private int offset = 0;
    public Map<Long, Integer> causes;
    int X;
    int Y;
    BufferedImage img;
    Matrix matrix;
    JLabel matrixImage = null;
    private JRadioButton yes = new JRadioButton("Yes");
    private JRadioButton no = new JRadioButton("No");

    public Visual(List<LexerToken> list, Parser parser) {
        this.causes = new HashMap<Long, Integer>();
        this.src = list;
        this.visited = new long[this.src.size() + 1][this.src.size() + 1];
        this.par = parser;
        this.zoom = 1 + 1300 / this.src.size();
        this.offset = this.zoom / 2;
        if (this.zoom == 1) {
            this.offset = 0;
        }
        int n = this.src.size();
        this.X = (n + 1) * this.zoom;
        this.Y = (n + 1) * this.zoom;
    }

    public void draw(Matrix matrix) {
        this.img = this.drawMatrix(matrix);
        JFrame jFrame = new JFrame(this.par.getClass().getSimpleName() + " Matrix");
        jFrame.setDefaultCloseOperation(3);
        final JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditorKit(new HTMLEditorKit());
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(1000, 1300));
        jScrollPane.setMinimumSize(new Dimension(100, 100));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.yes);
        buttonGroup.add(this.no);
        jPanel.add(new JLabel("Optimization: "));
        jPanel.add(this.yes);
        jPanel.add(this.no);
        this.yes.addActionListener(this);
        this.no.addActionListener(this);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        class ScrollablePicture
        extends JLabel
        implements Scrollable,
        MouseMotionListener,
        MouseWheelListener {
            int x0;
            int y0;
            Cell output;
            int index;
            int ambig;

            public ScrollablePicture() {
                super(new Icon(){

                    @Override
                    public int getIconHeight() {
                        return Visual.this.Y;
                    }

                    @Override
                    public int getIconWidth() {
                        return Visual.this.X;
                    }

                    @Override
                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        graphics.drawImage(Visual.this.img, 0, 0, Color.orange, null);
                        Visual.this.drawSrcText(graphics);
                    }
                });
                this.x0 = -1;
                this.y0 = -1;
                this.output = null;
                this.index = 0;
                this.ambig = 0;
                this.setAutoscrolls(true);
                this.addMouseMotionListener(this);
                this.addMouseWheelListener(this);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 10, 10);
                this.scrollRectToVisible(rectangle);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                mouseEvent.consume();
                int n = mouseEvent.getX() / Visual.this.zoom;
                int n2 = mouseEvent.getY() / Visual.this.zoom;
                if (n > Visual.this.src.size()) {
                    return;
                }
                if (n2 > Visual.this.src.size()) {
                    return;
                }
                if (n != this.x0 || n2 != this.y0) {
                    this.index = 0;
                    this.ambig = 0;
                }
                this.output = Visual.this.matrix.get(n, n2);
                if (this.output != null) {
                    this.x0 = n;
                    this.y0 = n2;
                    this.updatePane(jEditorPane);
                    this.repaint();
                } else if (this.x0 != -1) {
                    this.repaint();
                    this.x0 = -1;
                    this.y0 = -1;
                }
                String string = "<html><font color=rgb(150,100,100) size=+2>[" + n + "," + n2 + ")</font>";
                if (Visual.this.visited != null) {
                    int n3 = Service.lY(Visual.this.visited[n][n2]);
                    int n4 = Service.lX(Visual.this.visited[n][n2]);
                    string = string + " time = <font color=rgb(100,150,100) size=+2> " + (n3 + n4);
                    string = string + "</font> = <font color=rgb(150,100,100) size=+1> " + n3;
                    string = string + "</font> (completetion) + <font color=rgb(100,100,150)  size=+1> " + n4;
                }
                this.setToolTipText(string);
            }

            private void updatePane(JEditorPane jEditorPane2) {
                StringBuffer stringBuffer = new StringBuffer("<html><font color=red size=+1>[" + this.x0 + "," + this.y0 + ")</font><br>");
                this.updatePane4Earley(stringBuffer);
                stringBuffer.append("<font color=green  size=+1><br><br>");
                for (int i = this.x0; i < this.y0; ++i) {
                    stringBuffer.append(" " + Visual.this.src.get((int)i).content);
                }
                jEditorPane2.setText(stringBuffer.toString());
            }

            public void updatePane4Earley(StringBuffer stringBuffer) {
                for (int i = 0; i < this.output.size(); ++i) {
                    int n = this.output.getPosition(i);
                    int n2 = this.output.getRule(i);
                    int n3 = -1;
                    if (i == this.index) {
                        n3 = Visual.this.matrix.getEarleyBackptrs(this.x0, this.y0, this.output, i).get(this.ambig);
                    }
                    stringBuffer.append("<br>");
                    ((Earley)Visual.this.par).toHtml(n2, n, i == this.index, this.x0, n3, this.y0, Visual.this.matrix, stringBuffer);
                }
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return null;
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
                return 0;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
                return 0;
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (this.x0 != -1 && Visual.this.par instanceof Earley && this.x0 <= this.y0 && this.index < this.output.size()) {
                    graphics.setColor(Color.red);
                    int n = -1;
                    n = Visual.this.matrix.getEarleyBackptrs(this.x0, this.y0, this.output, this.index).get(this.ambig);
                    if (this.y0 < n) {
                        graphics.drawLine(this.x0 * Visual.this.zoom + Visual.this.offset, (this.y0 - 1) * Visual.this.zoom + Visual.this.offset, this.x0 * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset);
                        return;
                    }
                    if (this.x0 <= n) {
                        graphics.drawLine(this.x0 * Visual.this.zoom + Visual.this.offset, n * Visual.this.zoom + Visual.this.offset, this.x0 * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset);
                    }
                    graphics.drawLine(this.x0 * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset, n * Visual.this.zoom + Visual.this.offset, this.y0 * Visual.this.zoom + Visual.this.offset);
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (this.output == null) {
                    return;
                }
                int n = -1;
                n = Visual.this.matrix.getEarleyBackptrs(this.x0, this.y0, this.output, this.index).size();
                if (0 <= this.ambig + mouseWheelEvent.getWheelRotation() && this.ambig + mouseWheelEvent.getWheelRotation() < n) {
                    this.ambig += mouseWheelEvent.getWheelRotation();
                } else {
                    this.ambig = 0;
                    this.index += mouseWheelEvent.getWheelRotation() > 0 ? 1 : -1;
                    if (this.index < 0) {
                        this.index = this.output.size() + this.index;
                    }
                    if (this.index >= this.output.size()) {
                        this.index -= this.output.size();
                    }
                }
                this.repaint();
                this.updatePane(jEditorPane);
            }
        }
        this.matrixImage = new ScrollablePicture();
        jPanel2.add((Component)this.matrixImage, "Center");
        jPanel2.add((Component)jPanel, "East");
        JScrollPane jScrollPane2 = new JScrollPane(jPanel2);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        jScrollPane2.setPreferredSize(new Dimension(1350, 1350));
        jScrollPane2.setMinimumSize(new Dimension(300, 300));
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.add(jScrollPane2);
        jSplitPane.add(jScrollPane);
        jFrame.getContentPane().add(jSplitPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private BufferedImage drawMatrix(Matrix matrix) {
        Object object;
        int n;
        this.matrix = matrix;
        byte[] byArray = new byte[this.X * this.Y + 1];
        for (int i = 0; i < this.Y; ++i) {
            for (n = 0; n <= this.X; ++n) {
                int n2;
                int n3;
                int n4 = i * this.X + n;
                object = matrix.get(n / this.zoom, i / this.zoom);
                if (object != null) {
                    n3 = Service.lY(this.visited[n / this.zoom][i / this.zoom]);
                    n2 = Service.lX(this.visited[n / this.zoom][i / this.zoom]);
                    byArray[n4] = 13;
                    if (n3 + n2 < 10000) {
                        byArray[n4] = 14;
                    }
                    if (100000 < n3 + n2) {
                        byArray[n4] = 0;
                    }
                    if (1000000 >= n3 + n2) continue;
                    byArray[n4] = 7;
                    continue;
                }
                if (i < n || this.visited != null && this.visited[n / this.zoom][i / this.zoom] == 0L || this.visited == null) {
                    byArray[n4] = 1;
                    continue;
                }
                byArray[n4] = 4;
                if (this.visited == null || 5000 >= (n3 = Service.lY(this.visited[n / this.zoom][i / this.zoom])) + (n2 = Service.lX(this.visited[n / this.zoom][i / this.zoom]))) continue;
                byArray[n4] = 3;
            }
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, this.X * this.Y, 0);
        n = dataBufferByte.getNumBanks();
        int[] nArray = new int[]{15};
        object = new SinglePixelPackedSampleModel(0, this.X, this.Y, nArray);
        WritableRaster writableRaster = Raster.createWritableRaster((SampleModel)object, dataBufferByte, null);
        ColorModel colorModel = Visual.generateColorModel();
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        return bufferedImage;
    }

    private void drawSrcText(Graphics graphics) {
        if (this.zoom < 5) {
            return;
        }
        int n = -1;
        for (LexerToken lexerToken : this.src) {
            graphics.setColor(Color.WHITE);
            graphics.drawString(lexerToken.content, ++n * this.zoom + 2 * this.zoom / 3, (n + 1) * this.zoom + 2 * this.zoom / 3);
        }
    }

    private static ColorModel generateColorModel() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        byArray[0] = 0;
        byArray2[0] = 0;
        byArray3[0] = 0;
        byArray[1] = 0;
        byArray2[1] = 0;
        byArray3[1] = -64;
        byArray[2] = 0;
        byArray2[2] = 0;
        byArray3[2] = -1;
        byArray[3] = 0;
        byArray2[3] = -64;
        byArray3[3] = 0;
        byArray[4] = 0;
        byArray2[4] = -1;
        byArray3[4] = 0;
        byArray[5] = 0;
        byArray2[5] = -64;
        byArray3[5] = -64;
        byArray[6] = 0;
        byArray2[6] = -1;
        byArray3[6] = -1;
        byArray[7] = -64;
        byArray2[7] = 0;
        byArray3[7] = 0;
        byArray[8] = -1;
        byArray2[8] = 0;
        byArray3[8] = 0;
        byArray[9] = -64;
        byArray2[9] = 0;
        byArray3[9] = -64;
        byArray[10] = -1;
        byArray2[10] = 0;
        byArray3[10] = -1;
        byArray[11] = -64;
        byArray2[11] = -64;
        byArray3[11] = 0;
        byArray[12] = -1;
        byArray2[12] = -1;
        byArray3[12] = 0;
        byArray[13] = 80;
        byArray2[13] = 80;
        byArray3[13] = 80;
        byArray[14] = -64;
        byArray2[14] = -64;
        byArray3[14] = -64;
        byArray[15] = -1;
        byArray2[15] = -1;
        byArray3[15] = -1;
        return new IndexColorModel(4, 16, byArray, byArray2, byArray3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.recalculate(actionEvent.getSource() == this.yes);
    }

    public void recalculate(boolean bl) {
        this.causes = new HashMap<Long, Integer>();
        if (this.visited != null) {
            this.visited = new long[this.src.size() + 1][this.src.size() + 1];
            ((Earley)this.par).skipRanges = bl;
            this.matrix.allXs = null;
            this.matrix = new Matrix(this.par);
            this.matrix.visual = this;
            ((Earley)this.par).parse(this.src, this.matrix);
        }
        this.img = this.drawMatrix(this.matrix);
        this.matrixImage.repaint();
    }
}

