/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Set;

public class RuleTuple
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    public String head;
    public String[] rhs;

    public RuleTuple(String string, List<String> list) {
        this.head = string;
        this.rhs = new String[list.size()];
        int n = 0;
        for (String string2 : list) {
            this.rhs[n++] = string2;
        }
    }

    public RuleTuple(String string, String[] stringArray) {
        this.head = string;
        this.rhs = stringArray;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        throw new RuntimeException("hashCode inconsistent with equals");
    }

    public int compareTo(Object object) {
        int n;
        RuleTuple ruleTuple = (RuleTuple)object;
        int n2 = n = this.head == null ? 0 : this.head.compareTo(ruleTuple.head);
        if (n != 0) {
            return n;
        }
        if (this.rhs.length != ruleTuple.rhs.length) {
            return this.rhs.length - ruleTuple.rhs.length;
        }
        for (int i = 0; i < this.rhs.length; ++i) {
            if (this.rhs[i].compareTo(ruleTuple.rhs[i]) == 0) continue;
            return this.rhs[i].compareTo(ruleTuple.rhs[i]);
        }
        return 0;
    }

    public boolean ignore(String string, String string2, String string3) {
        boolean bl = false;
        for (String string4 : this.rhs) {
            if (string4.equals(string2)) {
                bl = true;
            }
            if (bl && string4.equals(string)) {
                return true;
            }
            if (!string4.equals(string3)) continue;
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.head != null) {
            stringBuffer.append(this.head + ":");
        }
        for (String string : this.rhs) {
            stringBuffer.append(" " + string);
        }
        return stringBuffer.toString();
    }

    public static void printRules(Set<RuleTuple> set) {
        RuleTuple ruleTuple = null;
        for (RuleTuple ruleTuple2 : set) {
            System.out.println(ruleTuple2.toHTML(ruleTuple));
            ruleTuple = ruleTuple2;
        }
    }

    public String toHTML(RuleTuple ruleTuple) {
        StringBuffer stringBuffer = new StringBuffer();
        if (ruleTuple == null || !ruleTuple.head.equals(this.head)) {
            stringBuffer.append(this.head + ":" + RuleTuple.identln(12 - this.head.length() - 2, " "));
        } else {
            stringBuffer.append(RuleTuple.identln(10, "| "));
        }
        for (String string : this.rhs) {
            stringBuffer.append(" " + string);
        }
        return stringBuffer.toString();
    }

    public static String identln(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static void memorizeRules(Set<RuleTuple> set, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(set);
        objectOutputStream.close();
    }

    public static Set<RuleTuple> getRules(URL uRL) throws Exception {
        InputStream inputStream = uRL.openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Set set = (Set)objectInputStream.readObject();
        objectInputStream.close();
        return set;
    }
}

