/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;

public abstract class Parser {
    public String[] allSymbols;
    public Map<String, Integer> symbolIndexes;

    public Parser(Set<RuleTuple> set) {
        this.extractSymbols(set);
    }

    protected void extractSymbols(Set<RuleTuple> set) {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("!nil");
        for (RuleTuple object : set) {
            if (object.head == null || object.rhs.length == 0 || object.rhs[0] == null || object.rhs.length > 1 && object.rhs[1] == null) {
                throw new RuntimeException("ct has null symbols");
            }
            treeSet.add(object.head);
            for (String string : object.rhs) {
                treeSet.add(string);
            }
        }
        this.allSymbols = new String[treeSet.size()];
        this.symbolIndexes = new HashMap<String, Integer>();
        int n = 0;
        for (String string : treeSet) {
            this.symbolIndexes.put(string, n);
            this.allSymbols[n] = string;
            ++n;
        }
    }

    public boolean isTerminal(int n) {
        return this.allSymbols[n].charAt(0) == '\'';
    }

    public ParseNode forest(List<LexerToken> list, Matrix matrix) {
        HashMap<Long, ParseNode> hashMap = new HashMap<Long, ParseNode>();
        try {
            ParseNode parseNode;
            int n = list.size();
            if (n == 0) {
                return new ParseNode(0, n, -1, -1, this);
            }
            Cell cell = matrix.get(0, n);
            if (cell != null && 0 < cell.size() && (parseNode = this.treeForACell(list, matrix, cell, 0, n, hashMap)) != null) {
                return parseNode;
            }
            parseNode = new ParseNode(0, n, -1, -1, this);
            for (int i = n - 1; i > 0; --i) {
                for (int j = 0; j < n - i + 1; ++j) {
                    ParseNode parseNode2;
                    int n2 = j + i;
                    cell = matrix.get(j, n2);
                    if (cell == null || (parseNode2 = this.treeForACell(list, matrix, cell, j, n2, hashMap)) == null) continue;
                    parseNode.addTopLevel(parseNode2);
                    parseNode2.parent = parseNode;
                    return parseNode;
                }
            }
            return new ParseNode(0, 1, -1, -1, this);
        }
        catch (AssertionError assertionError) {
            System.err.println("Parser.forest(): AssertionError" + ((Throwable)((Object)assertionError)).getMessage());
            return null;
        }
    }

    abstract ParseNode treeForACell(List<LexerToken> var1, Matrix var2, Cell var3, int var4, int var5, Map<Long, ParseNode> var6);

    public int getSymbol(String string) {
        try {
            return this.symbolIndexes.get(string);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("NPE: symbolIndexes.get(" + string + ")");
            return -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

