/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.Messages;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;

public class ThirdPartyUtil
extends DBUtil {
    private static QueryXMLSupport s_xml;

    private static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport(new MetaResource(ThirdPartyUtil.class.getClassLoader(), "oracle/dbtools/db/dbutilsql.xml"));
        }
        return s_xml;
    }

    protected ThirdPartyUtil(String string, Connection connection) {
        super(string, connection);
    }

    @Override
    public void setDBAction(String string) {
        Query query = ThirdPartyUtil.getXMLQueries().getQuery("ACTION", this.m_conn);
        this.execute(query.getSql(), Collections.singletonList(string == null ? "" : string));
    }

    @Override
    public void setDBModuleAction(String string) {
        Query query = ThirdPartyUtil.getXMLQueries().getQuery("MODULE", this.m_conn);
        this.execute(query.getSql(), Arrays.asList(s_prodName, string == null ? "" : string));
    }

    @Override
    public String getDBMSOUTPUT() {
        return "";
    }

    @Override
    public int getErrorOffset(final String string) {
        DBUtil.OperImpl<Integer> operImpl = new DBUtil.OperImpl<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws SQLException {
                Statement statement = null;
                if (DBUtil.s_conns.lock(ThirdPartyUtil.this.m_conn)) {
                    try {
                        Query query = ThirdPartyUtil.getXMLQueries().getQuery("ERR_SQL", ThirdPartyUtil.this.m_conn);
                        statement = ThirdPartyUtil.this.m_conn.prepareCall(query.getSql());
                        DBUtil.LOGGER.info(Messages.getString("DBUtil.55") + query.getSql());
                        statement.setString(1, string);
                        statement.setString(2, string);
                        statement.registerOutParameter(3, 4);
                        statement.execute();
                        Integer n = statement.getInt(3);
                        return n;
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        DBUtil.s_conns.unlock(ThirdPartyUtil.this.m_conn);
                    }
                }
                return 0;
            }
        };
        return this.lockForOperation(operImpl, 0);
    }

    @Override
    protected boolean hasTransaction() {
        DBUtil.OperImpl<Boolean> operImpl = new DBUtil.OperImpl<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                if (ThirdPartyUtil.this.m_conn == null || ThirdPartyUtil.this.m_conn.isClosed()) {
                    return false;
                }
                Query query = ThirdPartyUtil.getXMLQueries().getQuery("TRANSACTION", ThirdPartyUtil.this.m_conn);
                String string = ThirdPartyUtil.this.executeOracleReturnOneCol(query.getSql(), Collections.EMPTY_MAP);
                return ModelUtil.hasLength(string);
            }
        };
        return this.lockForOperation(operImpl, Boolean.FALSE);
    }

    @Override
    protected boolean isOracleConnectionAlive() {
        return false;
    }

    @Override
    public String addDbQuotes(String string, boolean bl) {
        char c = this.getQuoteCharacter();
        if (bl) {
            return string.indexOf(c) >= 0 ? string : c + string + c;
        }
        return string;
    }
}

