/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.ResultSet;
import java.sql.Statement;
import oracle.dbtools.db.ResultSetHolder;
import oracle.dbtools.db.ResultSetTracker;

public final class ResultSetWrapper {
    private ResultSetHolder m_holder;

    ResultSetWrapper(ResultSetHolder resultSetHolder) {
        this.m_holder = resultSetHolder;
    }

    public ResultSet getResultSet() {
        return this.m_holder.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ResultSetHolder resultSetHolder = null;
        ResultSetWrapper resultSetWrapper = this;
        synchronized (resultSetWrapper) {
            ResultSetTracker.untrackResultSet(this);
            resultSetHolder = this.m_holder;
            this.m_holder = null;
        }
        if (resultSetHolder != null) {
            resultSetHolder.close();
        }
    }

    ResultSetHolder getHolder() {
        return this.m_holder;
    }

    public static ResultSetWrapper createWrapper(ResultSet resultSet, Statement statement) {
        assert (resultSet != null);
        ResultSetHolder resultSetHolder = new ResultSetHolder(resultSet, statement);
        ResultSetWrapper resultSetWrapper = new ResultSetWrapper(resultSetHolder);
        ResultSetTracker.trackResultSet(resultSetWrapper);
        return resultSetWrapper;
    }
}

