/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DefaultConnectionResolver;

public class AdvancedConnectionResolver
extends DefaultConnectionResolver {
    private static ConnectionResolver _connectionResolver = null;
    private ArrayList<ConnectionDetails> _loadedConnections = new ArrayList();

    public static void setConnectionResolver(ConnectionResolver connectionResolver) {
        _connectionResolver = connectionResolver;
    }

    public static ConnectionResolver getInstance() {
        if (_connectionResolver == null) {
            _connectionResolver = new AdvancedConnectionResolver();
        }
        return _connectionResolver;
    }

    @Override
    public String getConnectionType(Connection connection) {
        for (ConnectionDetails connectionDetails : this._loadedConnections) {
            if (connectionDetails.getConn() != connection) continue;
            return connectionDetails.getType();
        }
        return "Oracle";
    }

    @Override
    public Connection getConnection(String string) throws Exception {
        if (string.startsWith("\"")) {
            return this.getConnectionFromURL(this.strip(string, '\"'));
        }
        return super.getConnection(string);
    }

    private String strip(String string, char c) {
        if ((string = string.trim()).charAt(0) == c && string.charAt(string.length() - 1) == c) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private Connection getConnectionFromURL(String string) {
        Connection connection = null;
        ConnectionDetails connectionDetails = new ConnectionDetails(string);
        for (ConnectionDetails connectionDetails2 : this._loadedConnections) {
            if (!connectionDetails.getUrl().equals(connectionDetails2.getUrl())) continue;
            connection = connectionDetails2.getConn();
            break;
        }
        if (connection == null) {
            this._loadedConnections.add(connectionDetails);
            connection = connectionDetails.getConn();
        }
        return connection;
    }
}

