/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.data.model.Baseable;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.Table;
import oracle.dbtools.db.DBUtil;
import oracle.jdbc.OraclePreparedStatement;

public class GenericTable
implements Baseable {
    private Table _table;
    private String _schemaName;

    public GenericTable(Connection connection, String string, String string2) {
        this.populateTable(connection, string, string2);
    }

    public GenericTable(Table table) {
        this._table = table;
    }

    public GenericTable() {
        this._table = new Table();
    }

    private void populateTable(Connection connection, String string, String string2) {
        this._table = this.getMetaData(connection, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table getMetaData(Connection connection, String string, String string2) {
        Table table = null;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        if (DBUtil.getConnectionResolver().lock(connection)) {
            try {
                OraclePreparedStatement oraclePreparedStatement;
                ResultSetMetaData resultSetMetaData;
                String string3 = "";
                String[] stringArray = string2.split("@");
                String string4 = DBUtil.addDoubleQuote(stringArray[0]);
                if (stringArray.length > 1) {
                    string4 = string4 + "@" + stringArray[1];
                }
                if ((resultSetMetaData = (oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string3 = string != null && string.length() > 0 ? "select * from " + DBUtil.addDoubleQuote(string) + "." + string4 + " where 1 = 2" : "select * from " + string4 + " where 1 = 2")).getMetaData()) != null) {
                    int n = resultSetMetaData.getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        Column column = new Column();
                        column.setName(resultSetMetaData.getColumnName(i + 1));
                        column.setNullable(resultSetMetaData.isNullable(i + 1) == 1);
                        column.setType(resultSetMetaData.getColumnTypeName(i + 1));
                        column.setPrecision(resultSetMetaData.getPrecision(i + 1));
                        column.setScale(resultSetMetaData.getScale(i + 1));
                        arrayList.add(column);
                    }
                    table = new Table();
                    table.setTablename(string2);
                    table.setColumns(arrayList);
                }
            }
            catch (Exception exception) {
                boolean bl = true;
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
        }
        return table;
    }

    public static void main(String[] stringArray) {
    }

    @Override
    public void addColumn(Column column) {
        this._table.addColumn(column);
    }

    @Override
    public Column getColumn(int n) {
        return this.getColumns()[n];
    }

    @Override
    public Column[] getColumns() {
        return this._table.getColumns().toArray(new Column[this._table.getColumns().size()]);
    }

    @Override
    public String getDataType(Column column) {
        return column.getType();
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    @Override
    public void setColumns(Column[] columnArray) {
        List<Column> list = this._table.getColumns();
        if (list != null) {
            list.clear();
            for (int i = 0; i < columnArray.length; ++i) {
                list.add(columnArray[i]);
            }
            this._table.setColumns(list.toArray(new Column[list.size()]));
        }
    }

    @Override
    public void setTableName(String string) {
        this._table.setTablename(string);
    }

    private boolean isExistsTable(Connection connection, boolean bl, String string, String string2) {
        if (connection == null) {
            return false;
        }
        HashMap hashMap = new HashMap();
        String string3 = "";
        String string4 = "select count(1) from ";
        if (string != null && string.length() > 0) {
            string4 = string4 + string + ".";
        }
        string4 = string4 + string2 + " where rownum =0";
        String string5 = DBUtil.getInstance(connection).executeOracleReturnOneCol(string4, hashMap);
        return string5 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isExistsTableSave(Connection connection, boolean bl, String string, String string2) {
        if (connection == null) {
            return false;
        }
        String string3 = " select 1 from " + (bl ? "dba_objects" : "all_objects") + " where owner = :OWNER " + " and object_type = 'TABLE' " + " and object_name = :NAME ";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        hashMap.put("OWNER", string);
        hashMap.put("NAME", string2);
        if (DBUtil.getConnectionResolver().lock(connection)) {
            block6: {
                boolean bl2;
                try {
                    resultSet = DBUtil.getInstance(connection).executeQuery(string3, hashMap);
                    if (!resultSet.next()) break block6;
                    bl2 = true;
                }
                catch (Exception exception) {
                    DBUtil.closeResultSet(resultSet);
                    DBUtil.getConnectionResolver().unlock(connection);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        DBUtil.getConnectionResolver().unlock(connection);
                        throw throwable;
                    }
                }
                DBUtil.closeResultSet(resultSet);
                DBUtil.getConnectionResolver().unlock(connection);
                return bl2;
            }
            DBUtil.closeResultSet(resultSet);
            DBUtil.getConnectionResolver().unlock(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList<Column> getColumnsSave(Connection connection, String string, String string2) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        hashMap.put("OWNER", string);
        hashMap.put("TAB", string2);
        String string3 = "select column_name, nullable from all_tab_cols where table_name = :TAB and owner = :OWNER ORDER BY COLUMN_ID";
        if (DBUtil.getConnectionResolver().lock(connection)) {
            try {
                resultSet = DBUtil.getInstance(connection).executeQuery(string3, hashMap);
                while (resultSet.next()) {
                    Column column = new Column();
                    column.setName(resultSet.getString(1));
                    column.setNullable(resultSet.getString(2).equals("Y"));
                    arrayList.add(column);
                }
            }
            catch (Exception exception) {
                DBUtil.closeResultSet(resultSet);
                DBUtil.getConnectionResolver().unlock(connection);
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    DBUtil.getConnectionResolver().unlock(connection);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet(resultSet);
            DBUtil.getConnectionResolver().unlock(connection);
        }
        return arrayList;
    }
}

