/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.util.Locale;
import java.util.Map;
import oracle.dbtools.data.loadservice.LoadServicesRegistry;

public class LoadParmsAPI {
    public static final int DEFAULT_ERRORS = 50;
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final int UNLIMITED = -1;
    public static int DEFAULT_BATCH_ROWS = 50;
    public static int DEFAULT_BATCHES_PER_COMMIT = 10;
    public static final String LOAD_TIMESTAMP_TZ_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF TZH:TZM";
    public static final String LOAD_TIMESTAMP_TZR_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF TZR";
    public static final String LOAD_TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF";
    public static final String LOAD_DATE_FORMAT = "YYYY-MM-DD";
    private SERVICE_METHOD _serviceMethod;
    private DELETE_ROWS _deleteRows;
    private boolean _isUnknownColumnsFail;
    private Map<String, String> _aliasToColumnMap;
    private int _errors;
    private int _errorsMax;
    private int _batchRows;
    private int _batchMax;
    private int _batchesPerCommit;
    private boolean _isDoCommit;
    private RESPONSE_FORMAT _responseFormat;
    private Iterable<Locale> _responseLocales;
    private String _responseEncoding;
    private Locale _locale;
    private String _dateFormat;
    private String _timestampFormat;
    private String _timestampTZFormat;

    public LoadParmsAPI(Builder builder) {
        this._serviceMethod = builder._serviceMethod;
        if (!LoadServicesRegistry.isServiceRegistered(this._serviceMethod.toString())) {
            throw new IllegalArgumentException();
        }
        this._deleteRows = builder._deleteRows;
        this._isUnknownColumnsFail = builder._isUnknownColumnsFail;
        this._aliasToColumnMap = builder._aliasToColumnMap;
        this._errors = builder._errors;
        this._errorsMax = builder._errorsMax;
        this._batchRows = builder._batchMax > 0 && builder._batchRows > builder._batchMax ? builder._batchMax : builder._batchRows;
        this._batchesPerCommit = builder._batchesPerCommit;
        this._isDoCommit = builder._isDoCommit;
        this._responseFormat = builder._responseFormat;
        this._responseEncoding = builder._responseEncoding;
        this._responseLocales = builder._responseLocales;
        this._locale = builder._locale;
        this._dateFormat = this.notNull(builder._dateFormat);
        this._timestampFormat = this.notNull(builder._timestampFormat);
        this._timestampTZFormat = this.notNull(builder._timestampTZFormat);
        this.validateParm(PARMS.SERVICE_METHOD, (Object)this._serviceMethod);
    }

    private void validateParm(Enum<PARMS> enum_, Object object) {
        if (object == null || object instanceof String && ((String)object).length() == 0) {
            throw new IllegalStateException(enum_.toString());
        }
    }

    private String notNull(String string) {
        return string != null ? string : "";
    }

    public SERVICE_METHOD getMethod() {
        return this._serviceMethod;
    }

    public DELETE_ROWS getDeleteRows() {
        return this._deleteRows;
    }

    public boolean isUnknownColumnsFail() {
        return this._isUnknownColumnsFail;
    }

    public Map<String, String> getAliasToColumnMap() {
        return this._aliasToColumnMap;
    }

    public int getErrors() {
        return this._errors;
    }

    public int getErrorsMax() {
        return this._errorsMax;
    }

    public boolean isErrorsLimited() {
        return this._errors > 0 || this._errorsMax > 0;
    }

    public int getErrorsLimit() {
        return this._errors < this._errorsMax || this._errorsMax == -1 ? this._errors : this._errorsMax;
    }

    public final int getBatchRows() {
        return this._batchRows;
    }

    public int getBatchesPerCommit() {
        return this._batchesPerCommit;
    }

    public boolean isDoCommit() {
        return this._isDoCommit;
    }

    public RESPONSE_FORMAT getResponseFormat() {
        return this._responseFormat;
    }

    public boolean isResponseFormatRaw() {
        return this._responseFormat == RESPONSE_FORMAT.RESPONSE_RAW;
    }

    public boolean isResponseFormatSql() {
        return this._responseFormat == RESPONSE_FORMAT.RESPONSE_SQL;
    }

    public String getResponseEncoding() {
        return this._responseEncoding;
    }

    public Iterable<Locale> getResponseLocales() {
        return this._responseLocales;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getDataFormat() {
        return this._dateFormat;
    }

    public String getTimestampFormat() {
        return this._timestampFormat;
    }

    public String getTimestampTZFormat() {
        return this._timestampTZFormat;
    }

    public static class Builder {
        private SERVICE_METHOD _serviceMethod;
        private boolean _isUnknownColumnsFail = true;
        private Map<String, String> _aliasToColumnMap;
        private DELETE_ROWS _deleteRows = DELETE_ROWS.FALSE;
        private int _errors = 50;
        private int _errorsMax = -1;
        private int _batchRows = DEFAULT_BATCH_ROWS;
        private int _batchMax = -1;
        private int _batchesPerCommit = DEFAULT_BATCHES_PER_COMMIT;
        private boolean _isDoCommit = true;
        private RESPONSE_FORMAT _responseFormat = RESPONSE_FORMAT.RESPONSE_RAW;
        private String _responseEncoding = "UTF8";
        private Iterable<Locale> _responseLocales;
        private Locale _locale;
        private String _dateFormat = "";
        private String _timestampFormat = "";
        private String _timestampTZFormat = "";

        public Builder(SERVICE_METHOD sERVICE_METHOD) {
            this._serviceMethod = sERVICE_METHOD;
        }

        public Builder deleteRows(DELETE_ROWS dELETE_ROWS) {
            this._deleteRows = dELETE_ROWS;
            return this;
        }

        public Builder unknownColumnsFail(boolean bl) {
            this._isUnknownColumnsFail = bl;
            return this;
        }

        public Builder mapColumnNames(Map<String, String> map) {
            this._aliasToColumnMap = map;
            return this;
        }

        public Builder errors(int n) {
            this._errors = n;
            return this;
        }

        public Builder errorsMax(int n) {
            this._errorsMax = n;
            return this;
        }

        public Builder batchRows(int n) {
            this._batchRows = n;
            return this;
        }

        public Builder batchMax(int n) {
            this._batchMax = n;
            return this;
        }

        public Builder batchesPerCommit(int n) {
            this._batchesPerCommit = n;
            return this;
        }

        public Builder doCommit(boolean bl) {
            this._isDoCommit = bl;
            return this;
        }

        public Builder responseFormat(RESPONSE_FORMAT rESPONSE_FORMAT) {
            this._responseFormat = rESPONSE_FORMAT;
            return this;
        }

        public Builder responseEncoding(String string) {
            this._responseEncoding = string;
            return this;
        }

        public Builder responseLocales(Iterable<Locale> iterable) {
            this._responseLocales = iterable;
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder dateFormat(String string) {
            this._dateFormat = string;
            return this;
        }

        public Builder timestampFormat(String string) {
            this._timestampFormat = string;
            return this;
        }

        public Builder timestampTZFormat(String string) {
            this._timestampTZFormat = string;
            return this;
        }

        public LoadParmsAPI build() {
            return new LoadParmsAPI(this);
        }
    }

    private static enum PARMS {
        SERVICE_METHOD,
        DELETE_ROWS,
        UNKNOWN_COLUMNS_FAIL,
        MAP_COLUMN_NAMES,
        ERRORS,
        ERRORS_MAX,
        BATCH_ROWS,
        BATCH_MAX,
        BATCHES_PER_COMMIT,
        DO_COMMIT,
        RESPONSE_FORMAT,
        RESPONSE_ENCODING,
        RESPONSE_LOCALES,
        LOCALE,
        DATE_FORMAT,
        TIMESTAMP_FORMAT,
        TIMESTAMPTZ_FORMAT;

    }

    public static enum SERVICE_METHOD {
        JDBC_BATCH;

    }

    public static enum DELETE_ROWS {
        FALSE,
        TRUE,
        TRUNCATE;

    }

    public static enum RESPONSE_FORMAT {
        RESPONSE_RAW,
        RESPONSE_SQL;

    }
}

