/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.common;

import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dbtools.data.common.Iterables;
import oracle.dbtools.data.common.Translatable;
import oracle.dbtools.data.common.Translatables;

class TranslatableTemplate
implements Translatable {
    private final Class<?> baseClass;
    private final String defaultTemplate;
    private final String messageId;

    TranslatableTemplate(Class<?> clazz, String string, String string2) {
        this.baseClass = clazz;
        this.messageId = string;
        this.defaultTemplate = string2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TranslatableTemplate translatableTemplate = (TranslatableTemplate)object;
        if (this.baseClass == null ? translatableTemplate.baseClass != null : !this.baseClass.getName().equals(translatableTemplate.baseClass.getName())) {
            return false;
        }
        if (this.defaultTemplate == null ? translatableTemplate.defaultTemplate != null : !this.defaultTemplate.equals(translatableTemplate.defaultTemplate)) {
            return false;
        }
        return !(this.messageId == null ? translatableTemplate.messageId != null : !this.messageId.equals(translatableTemplate.messageId));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.baseClass == null ? 0 : this.baseClass.getName().hashCode());
        n = 31 * n + (this.defaultTemplate == null ? 0 : this.defaultTemplate.hashCode());
        n = 31 * n + (this.messageId == null ? 0 : this.messageId.hashCode());
        return n;
    }

    public String toString() {
        return this.toString(Iterables.iterable(Locale.getDefault()));
    }

    @Override
    public String toString(Iterable<Locale> iterable) {
        String string;
        ResourceBundle resourceBundle;
        String string2 = this.defaultTemplate;
        if (this.baseClass != null && (resourceBundle = Translatables.getBundle(this.baseClass, iterable)) != null && (string = resourceBundle.getString(this.messageId)) != null) {
            string2 = string;
        }
        return string2;
    }
}

