/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.app.Obfuscator;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class SqlRecognizer {
    static final String path = "/oracle/dbtools/app/";
    static Parsed prg = null;
    static SqlProgram programInstance = null;

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(SqlRecognizer.class, "test.sql");
        System.out.println(SqlRecognizer.getColumns(string));
        System.out.println(SqlRecognizer.getTables(string));
        System.out.println(SqlRecognizer.getPredicates(string));
        System.out.println(SqlRecognizer.getOrderBy(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Set<Long>> recognize(String string, List<LexerToken> list) {
        try {
            if (prg == null) {
                prg = new Parsed(Service.readFile(Obfuscator.class, "/oracle/dbtools/app/recognize.prg"), Program.getArboriParser(), "program");
            }
            Parsed parsed = new Parsed(string, list, SqlEarley.fullRecognizer(), null);
            if (programInstance == null) {
                programInstance = new SqlProgram();
                Program.debug = false;
                programInstance.program(prg.getRoot(), prg.getSrc(), prg.getInput());
            }
            Map<String, MaterializedPredicate> map = programInstance.eval(parsed);
            TreeMap<String, Set<Long>> treeMap = new TreeMap<String, Set<Long>>();
            Iterator<String> iterator = map.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return treeMap;
                }
                String string2 = iterator.next();
                String string3 = string2.substring(1, string2.length() - 1);
                this.fetch(string3, list, map, treeMap);
            }
        }
        catch (SyntaxError syntaxError) {
            throw syntaxError;
        }
        catch (AssertionError assertionError) {
            System.err.println(((Throwable)((Object)assertionError)).getMessage());
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void fetch(String string, List<LexerToken> list, Map<String, MaterializedPredicate> map, Map<String, Set<Long>> map2) {
        MaterializedPredicate materializedPredicate = map.get("\"" + string + "\"");
        HashSet<Long> hashSet = new HashSet<Long>();
        if (null == materializedPredicate.getAttribute(string)) {
            return;
        }
        map2.put(string, hashSet);
        for (int i = 0; i < materializedPredicate.cardinality(); ++i) {
            ParseNode parseNode = materializedPredicate.getAttribute(i, string);
            LexerToken lexerToken = list.get(parseNode.from);
            LexerToken lexerToken2 = list.get(parseNode.to - 1);
            hashSet.add(Service.lPair(lexerToken.begin, lexerToken2.end));
        }
    }

    public static Map<Integer, String> fragmentAtLocation(String string, String string2) {
        List<LexerToken> list = LexerToken.parse(string);
        SqlRecognizer sqlRecognizer = new SqlRecognizer();
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        Map<String, Set<Long>> map = sqlRecognizer.recognize(string, list);
        for (String string3 : map.keySet()) {
            if (!string2.equals(string3)) continue;
            for (Long l : map.get(string3)) {
                int n = Service.lX(l);
                int n2 = Service.lY(l);
                treeMap.put(n, string.substring(n, n2));
            }
        }
        return treeMap;
    }

    public static List<String> getList(String string, String string2) {
        Map<Integer, String> map = SqlRecognizer.fragmentAtLocation(string, string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = -1;
        for (int n2 : map.keySet()) {
            if (n2 <= n) {
                throw new AssertionError((Object)"pos <= lastPos");
            }
            linkedList.add(map.get(n2));
            n = n2;
        }
        return linkedList;
    }

    public static List<String> getColumns(String string) {
        return SqlRecognizer.getList(string, "columnSelect");
    }

    public static List<String> getTables(String string) {
        return SqlRecognizer.getList(string, "tableFrom");
    }

    public static List<String> getPredicates(String string) {
        return SqlRecognizer.getList(string, "predicateWhere");
    }

    public static List<String> getOrderBy(String string) {
        return SqlRecognizer.getList(string, "orderBy");
    }
}

