/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.app.Obfuscator;
import oracle.dbtools.app.SqlId;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.util.Service;

public abstract class Rewrite {
    public int fileCnt = 0;
    private Set<String> fileExtensions;

    public Rewrite(Set<String> set) {
        this.fileExtensions = set;
    }

    public void walkDir(File file) throws FileNotFoundException, Exception {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.walkDir(file2);
            }
        } else {
            this.rewrite(file);
        }
    }

    public void rewrite(File file) throws FileNotFoundException, Exception {
        int n;
        String string = file.getName();
        if (string.length() > 4 && (n = string.lastIndexOf(46)) >= 0 && n < string.length() - 3) {
            String string2 = "*" + string.substring(n).toLowerCase();
            if (this.fileExtensions.contains("*.*") || this.fileExtensions.contains(string2)) {
                ParseNode parseNode;
                List<LexerToken> list;
                String string3 = Service.readFile(new FileInputStream(file));
                String string4 = this.transform(string3, list = LexerToken.parse(string3), (LazyNode)(parseNode = StackParser.getInstance().parse((List)list)));
                if (string4 != null) {
                    FileWriter fileWriter = new FileWriter(file);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(string4.toString());
                    bufferedWriter.close();
                }
                ++this.fileCnt;
            }
        }
    }

    public abstract String transform(String var1, List<LexerToken> var2, LazyNode var3);

    protected abstract String found();

    protected abstract String changed();

    public String log() {
        return "Processed " + this.fileCnt + " files, " + this.found() + this.changed();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "Usage: java -jar <utils-nodeps.jar> \n<command> (e.g. \"sqlid\", \"obfuscate\") \n<directory> <sqlid_prefix>) \ne.g. \njava -jar C:\\sqld\\sqldeveloper\\lib\\oracle.sqldeveloper.utils-nodeps.jar\nobfuscate . \njava -jar C:\\sqld\\sqldeveloper\\lib\\oracle.sqldeveloper.utils-nodeps.jar\nsqlid C:\\Apex_code APEX";
        switch (stringArray.length) {
            default: {
                System.out.println(string);
                return;
            }
            case 2: 
            case 3: 
        }
        File file = new File(stringArray[1]);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("*.plb");
        hashSet.add("*.pls");
        hashSet.add("*.pkb");
        if (!file.exists()) {
            System.out.println("Specified directory does not exist.");
        }
        Rewrite rewrite = null;
        if ("sqlid".equalsIgnoreCase(stringArray[0]) && stringArray.length == 3) {
            rewrite = new SqlId(stringArray[2], hashSet);
        } else if ("obfuscate".equalsIgnoreCase(stringArray[0]) && stringArray.length == 2) {
            rewrite = new Obfuscator(hashSet);
        } else {
            System.out.println(string);
            return;
        }
        rewrite.walkDir(file);
        System.out.println(rewrite.log());
    }
}

