/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.net.URI;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.auth.AuthenticationFailedException;
import oracle.dbtools.util.URIUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;

public abstract class SessionType {
    private static final String AUTH_PATH = "oauth2/token";

    public abstract String getType();

    protected abstract String getClientID();

    protected abstract String getClientSecret();

    public URI getAuthenticationURI(SessionInfo info) {
        URI root = info.getServerRoot();
        return URIUtils.newURI((URI)root, (String)this.getDefaultAuthenticationPath());
    }

    protected final String getDefaultAuthenticationPath() {
        return AUTH_PATH;
    }

    public final void signRequest(HttpRequest request) throws AuthenticationFailedException {
        Header header;
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.getClientID(), this.getClientSecret());
        BasicScheme scheme = new BasicScheme();
        try {
            header = scheme.authenticate((Credentials)creds, request);
        }
        catch (AuthenticationException e) {
            throw new AuthenticationFailedException(e);
        }
        request.addHeader(header);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.getType();
    }

    public boolean canSavePasswords() {
        return false;
    }
}

