/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.net.URI;
import java.util.Arrays;
import oracle.dbtools.common.utils.ModelUtil;

public final class SessionInfo {
    private final String m_name;
    private final URI m_root;
    private final String m_user;
    private final char[] m_pwd;
    private final URI m_serviceRoot;
    private final SftpInfo m_sftpInfo;
    private final OssInfo m_ossInfo;

    public SessionInfo(String name, URI root, URI serviceRoot, String username, char[] pwd) {
        this(name, root, serviceRoot, username, pwd, null);
    }

    public SessionInfo(String name, URI root, URI serviceRoot, String username, char[] pwd, SftpInfo sftpInfo) {
        this(name, root, serviceRoot, username, pwd, sftpInfo, null);
    }

    public SessionInfo(String name, URI root, URI serviceRoot, String username, char[] pwd, SftpInfo sftpInfo, OssInfo ossInfo) {
        this.m_name = name;
        this.m_root = root;
        this.m_serviceRoot = serviceRoot;
        this.m_user = username;
        this.m_pwd = pwd;
        this.m_sftpInfo = sftpInfo;
        this.m_ossInfo = ossInfo;
    }

    public String getName() {
        return this.m_name;
    }

    public URI getServerRoot() {
        return this.m_root;
    }

    public URI getServiceRoot() {
        return this.m_serviceRoot;
    }

    public String getUsername() {
        return this.m_user;
    }

    public char[] getPassword() {
        return this.m_pwd;
    }

    public SftpInfo getSftpInfo() {
        return this.m_sftpInfo;
    }

    public OssInfo getOssInfo() {
        return this.m_ossInfo;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SessionInfo && ModelUtil.areEqual((Object)this.m_name, (Object)((SessionInfo)obj).m_name) && ModelUtil.areEqual((Object)this.m_root, (Object)((SessionInfo)obj).m_root) && ModelUtil.areEqual((Object)this.m_serviceRoot, (Object)((SessionInfo)obj).m_serviceRoot) && ModelUtil.areEqual((Object)this.m_user, (Object)((SessionInfo)obj).m_user) && ModelUtil.areEqual((Object)this.m_pwd, (Object)((SessionInfo)obj).m_pwd) && ModelUtil.areEqual((Object)this.m_sftpInfo, (Object)((SessionInfo)obj).m_sftpInfo) && ModelUtil.areEqual((Object)this.m_ossInfo, (Object)((SessionInfo)obj).m_ossInfo);
    }

    public String toString() {
        return this.m_name + "#" + this.m_root + "#" + this.m_serviceRoot + "#" + this.m_user + "#" + this.m_sftpInfo != null ? this.m_sftpInfo.toString() : ("" + this.m_ossInfo != null ? this.m_ossInfo.toString() : "");
    }

    public static final class OssInfo {
        private boolean m_ossEnabled;
        private String m_ossServiceName;
        private String m_ossIdentityDomain;
        private String m_ossUserName;
        private char[] m_ossPassword;

        public OssInfo(boolean ossEnabled, String ossServiceName, String ossIdentityDomain, String ossUserName, char[] ossPassword) {
            this.m_ossEnabled = ossEnabled;
            this.m_ossServiceName = ossServiceName;
            this.m_ossIdentityDomain = ossIdentityDomain;
            this.m_ossUserName = ossUserName;
            this.m_ossPassword = Arrays.copyOf(ossPassword, ossPassword.length);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean isOssEnabled() {
            return this.m_ossEnabled;
        }

        public void setOssEnabled(boolean ossEnabled) {
            this.m_ossEnabled = ossEnabled;
        }

        public String getOssServiceName() {
            return this.m_ossServiceName;
        }

        public void setOssServiceName(String ossServiceName) {
            this.m_ossServiceName = ossServiceName;
        }

        public String getOssIdentityDomain() {
            return this.m_ossIdentityDomain;
        }

        public void setOssIdentityDomain(String ossIdentityDomain) {
            this.m_ossIdentityDomain = ossIdentityDomain;
        }

        public String getOssUserName() {
            return this.m_ossUserName;
        }

        public void setOssUserName(String ossUserName) {
            this.m_ossUserName = ossUserName;
        }

        public char[] getOssPassword() {
            return this.m_ossPassword;
        }

        public void setOssPassword(char[] ossPassword) {
            this.m_ossPassword = ossPassword;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof OssInfo && this.m_ossEnabled == ((OssInfo)obj).m_ossEnabled && ModelUtil.areEqual((Object)this.m_ossServiceName, (Object)((OssInfo)obj).m_ossServiceName) && ModelUtil.areEqual((Object)this.m_ossIdentityDomain, (Object)((OssInfo)obj).m_ossIdentityDomain) && ModelUtil.areEqual((Object)this.m_ossUserName, (Object)((OssInfo)obj).m_ossUserName) && ModelUtil.areEqual((Object)this.m_ossPassword, (Object)((OssInfo)obj).m_ossPassword);
        }

        public String toString() {
            return this.m_ossIdentityDomain + "#" + this.m_ossUserName + "#" + this.m_ossServiceName;
        }
    }

    public static final class SftpInfo {
        public static final int UNSPECIFIED_PORT_VALUE = -1;
        private String m_ftpUser;
        private char[] m_ftpPass;
        private String m_ftpHost;
        private int m_ftpPort;

        public SftpInfo(String ftpUser, char[] ftpPass, String ftpHost, int ftpPort) {
            this.m_ftpUser = ftpUser;
            this.m_ftpPass = ftpPass;
            this.m_ftpHost = ftpHost;
            this.m_ftpPort = ftpPort;
        }

        public String getSftpUser() {
            return this.m_ftpUser;
        }

        public char[] getSftpPass() {
            return this.m_ftpPass;
        }

        public String getSftpHost() {
            return this.m_ftpHost;
        }

        public int getSftpPort() {
            return this.m_ftpPort;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof SftpInfo && ModelUtil.areEqual((Object)this.m_ftpHost, (Object)((SftpInfo)obj).m_ftpHost) && this.m_ftpPort == ((SftpInfo)obj).m_ftpPort && ModelUtil.areEqual((Object)this.m_ftpUser, (Object)((SftpInfo)obj).m_ftpUser) && ModelUtil.areEqual((Object)this.m_ftpPass, (Object)((SftpInfo)obj).m_ftpPass);
        }

        public String toString() {
            return this.m_ftpUser + "#" + this.m_ftpHost + "#" + this.m_ftpPort;
        }
    }
}

