/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import oracle.dbtools.http.Client;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.SessionManager;
import oracle.dbtools.http.auth.Authentication;
import oracle.dbtools.http.auth.AuthenticationFailedException;

public final class SessionCreator {
    private final Client mClient;

    public static SessionCreator createSessionCreator(Client client) {
        return new SessionCreator(client);
    }

    static SessionCreator createSessionCreator(SessionManager manager) {
        return new SessionCreator(manager.getClient());
    }

    private SessionCreator(Client client) {
        this.mClient = client;
    }

    public Session createSession(SessionInfo info) throws SessionException {
        Authentication auth;
        String name = info.getName();
        try {
            auth = this.mClient.getAuthenticationEngine().authenticate(info);
        }
        catch (AuthenticationFailedException e) {
            throw new SessionException((Throwable)((Object)e));
        }
        Session conn = new Session(info, this.mClient, auth);
        conn.open();
        return conn;
    }
}

