/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.a;
import oracle.security.crypto.util.g;

public final class UnsyncHashtable
extends Dictionary
implements Cloneable,
Serializable {
    private transient g[] a;
    private transient int b;
    private int c;
    private float d;

    public UnsyncHashtable(int n, float f2) {
        if (n <= 0 || (double)f2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.d = f2;
        this.a = new g[n];
        this.c = (int)((float)n * f2);
    }

    public UnsyncHashtable(int n) {
        this(n, 0.75f);
    }

    public UnsyncHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.b;
    }

    public boolean isEmpty() {
        return this.b == 0;
    }

    public Enumeration keys() {
        return new a(this, this.a, true);
    }

    public Enumeration elements() {
        return new a(this, this.a, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        g[] gArray = this.a;
        int n = gArray.length;
        while (n-- > 0) {
            g g2 = gArray[n];
            while (g2 != null) {
                if (g2.c.equals(object)) {
                    return true;
                }
                g2 = g2.d;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        g[] gArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % gArray.length;
        g g2 = gArray[n2];
        while (g2 != null) {
            if (g2.a == n && g2.b.equals(object)) {
                return true;
            }
            g2 = g2.d;
        }
        return false;
    }

    public Object get(Object object) {
        g[] gArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % gArray.length;
        g g2 = gArray[n2];
        while (g2 != null) {
            if (g2.a == n && g2.b.equals(object)) {
                return g2.c;
            }
            g2 = g2.d;
        }
        return null;
    }

    protected void a() {
        int n = this.a.length;
        g[] gArray = this.a;
        int n2 = n * 2 + 1;
        g[] gArray2 = new g[n2];
        this.c = (int)((float)n2 * this.d);
        this.a = gArray2;
        int n3 = n;
        while (n3-- > 0) {
            g g2 = gArray[n3];
            while (g2 != null) {
                g g3 = g2;
                g2 = g2.d;
                int n4 = (g3.a & Integer.MAX_VALUE) % n2;
                g3.d = gArray2[n4];
                gArray2[n4] = g3;
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        g[] gArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % gArray.length;
        g g2 = gArray[n2];
        while (g2 != null) {
            if (g2.a == n && g2.b.equals(object)) {
                Object object3 = g2.c;
                g2.c = object2;
                return object3;
            }
            g2 = g2.d;
        }
        if (this.b >= this.c) {
            this.a();
            return this.put(object, object2);
        }
        g2 = new g(this, null);
        g2.a = n;
        g2.b = object;
        g2.c = object2;
        g2.d = gArray[n2];
        gArray[n2] = g2;
        ++this.b;
        return null;
    }

    public Object remove(Object object) {
        g[] gArray = this.a;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % gArray.length;
        g g2 = gArray[n2];
        g g3 = null;
        while (g2 != null) {
            if (g2.a == n && g2.b.equals(object)) {
                if (g3 != null) {
                    g3.d = g2.d;
                } else {
                    gArray[n2] = g2.d;
                }
                --this.b;
                return g2.c;
            }
            g3 = g2;
            g2 = g2.d;
        }
        return null;
    }

    public void clear() {
        g[] gArray = this.a;
        int n = gArray.length;
        while (--n >= 0) {
            gArray[n] = null;
        }
        this.b = 0;
    }

    public Object clone() {
        try {
            UnsyncHashtable unsyncHashtable = (UnsyncHashtable)super.clone();
            unsyncHashtable.a = new g[this.a.length];
            int n = this.a.length;
            while (n-- > 0) {
                unsyncHashtable.a[n] = this.a[n] != null ? (g)this.a[n].clone() : null;
            }
            return unsyncHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i2 = 0; i2 <= n; ++i2) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i2 >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.a.length);
        objectOutputStream.writeInt(this.b);
        for (int i2 = this.a.length - 1; i2 >= 0; --i2) {
            g g2 = this.a[i2];
            while (g2 != null) {
                objectOutputStream.writeObject(g2.b);
                objectOutputStream.writeObject(g2.c);
                g2 = g2.d;
            }
        }
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.d) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.a = new g[n3];
        this.b = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

