/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.security.SecureRandom;
import oracle.security.crypto.core.EntropySource;
import oracle.security.crypto.fips.FIPS_140_2;

public class SREntropySource
extends EntropySource {
    private SecureRandom a;

    public SREntropySource() {
        this.a = new SecureRandom();
        FIPS_140_2.assertReadyState();
    }

    public SREntropySource(SecureRandom secureRandom) {
        this.a = secureRandom;
        FIPS_140_2.assertReadyState();
    }

    public byte generateByte() {
        FIPS_140_2.assertReadyState();
        byte[] byArray = this.a.generateSeed(1);
        byte by = byArray[0];
        byArray[0] = 0;
        return by;
    }

    public void clear() {
    }

    public synchronized byte[] generateBytes(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        byte[] byArray2 = this.a.generateSeed(byArray.length);
        System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            byArray2[i2] = 0;
        }
        return byArray;
    }
}

