/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.MAC;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.k;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.Utils;

public final class HMAC
extends MAC {
    private AlgorithmIdentifier b;
    private SymmetricKey c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private int g;
    private int h;
    private MessageDigest i;
    private MessageDigest j;
    private MessageDigest.MDState k;
    private MessageDigest.MDState l;
    private byte[] m;
    private boolean n;

    public HMAC() {
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws AlgorithmIdentifierException {
        this.c = symmetricKey;
        this.d = (byte[])symmetricKey.d().clone();
        this.g = 0;
        this.h = this.d.length;
        this.i = MessageDigest.getInstance(algorithmIdentifier);
        this.j = MessageDigest.getInstance(algorithmIdentifier);
        this.c();
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, int n, int n2) throws AlgorithmIdentifierException {
        this.d = (byte[])byArray.clone();
        this.g = n;
        this.h = n2;
        this.i = MessageDigest.getInstance(algorithmIdentifier);
        this.j = MessageDigest.getInstance(algorithmIdentifier);
        this.c();
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws AlgorithmIdentifierException {
        this(algorithmIdentifier, byArray, 0, byArray.length);
    }

    private HMAC(byte[] byArray, int n, int n2) {
        FIPS_140_2.assertReadyState();
        this.d = (byte[])byArray.clone();
        this.g = n;
        this.h = n2;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        oracle.security.crypto.core.k.a(symmetricKey, 4096);
        if (algorithmIdentifier.getOID().equals(AlgID.hmacMD5.getOID())) {
            this.b = AlgID.md5;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacSHA.getOID())) {
            this.b = AlgID.sha1;
        } else {
            throw new AlgorithmIdentifierException("Unrecognized algorithm identifier for HMAC: " + algorithmIdentifier.toString());
        }
        this.i = MessageDigest.getInstance(this.b);
        this.j = MessageDigest.getInstance(this.b);
        if (symmetricKey == null) {
            this.d = new byte[0];
            this.g = 0;
            this.h = 0;
        } else {
            this.d = (byte[])symmetricKey.d().clone();
            this.g = 0;
            this.h = this.d.length;
        }
        this.c = symmetricKey;
        this.c();
        this.a = algorithmIdentifier;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier.getOID().equals(AlgID.hmacMD5.getOID())) {
            this.b = AlgID.md5;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacSHA.getOID())) {
            this.b = AlgID.sha1;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacWithSHA256.getOID())) {
            this.b = AlgID.sha_256;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacWithSHA384.getOID())) {
            this.b = AlgID.sha_384;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacWithSHA512.getOID())) {
            this.b = AlgID.sha_512;
        } else {
            throw new AlgorithmIdentifierException("Unrecognized algorithm identifier for HMAC: " + algorithmIdentifier.toString());
        }
        this.i = MessageDigest.getInstance(this.b);
        this.j = MessageDigest.getInstance(this.b);
        if (this.d == null) {
            this.d = new byte[0];
            this.g = 0;
            this.h = 0;
        } else {
            this.c();
        }
        this.a = algorithmIdentifier;
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public void setKey(byte[] byArray, int n, int n2) {
        FIPS_140_2.assertReadyState();
        this.d = (byte[])byArray.clone();
        this.g = n;
        this.h = n2;
        this.c();
    }

    public void setKey(byte[] byArray) {
        this.setKey(byArray, 0, byArray.length);
    }

    public void init() {
        this.i.a(this.k);
        this.j.a(this.l);
        this.n = false;
    }

    private void c() {
        byte[] byArray;
        int n = this.i.blockSize();
        int n2 = this.j.getDigestLength();
        if (this.h > n) {
            this.i.init();
            this.i.update(this.d, this.g, this.h);
            this.i.computeCurrent();
            byArray = this.i.a();
            this.i.init();
        } else {
            byArray = new byte[this.h];
            System.arraycopy(this.d, this.g, byArray, 0, this.h);
        }
        this.m = new byte[n2];
        this.e = new byte[n];
        this.f = new byte[n];
        Utils.setArray(this.e, (byte)54);
        Utils.setArray(this.f, (byte)92);
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray.length) {
            int n5 = n3;
            this.e[n5] = (byte)(this.e[n5] ^ byArray[n4]);
            int n6 = n3++;
            this.f[n6] = (byte)(this.f[n6] ^ byArray[n4]);
            ++n4;
        }
        this.i.update(this.e);
        this.i.computeCurrent();
        this.j.update(this.f);
        this.j.computeCurrent();
        this.k = (MessageDigest.MDState)this.i.b().clone();
        this.l = (MessageDigest.MDState)this.j.b().clone();
        this.n = false;
        Utils.setArray(byArray, (byte)0);
    }

    public void update(byte by) {
        this.i.update(by);
        this.n = false;
    }

    public void update(byte[] byArray, int n, int n2) {
        this.i.update(byArray, n, n2);
        this.n = false;
    }

    public void computeCurrent() {
        MessageDigest messageDigest = (MessageDigest)this.i.clone();
        this.i.computeCurrent();
        this.j.update(this.i.a());
        this.j.computeCurrent();
        System.arraycopy(this.j.a(), 0, this.m, 0, this.m.length);
        this.n = true;
        this.i = messageDigest;
        this.j.a(this.l);
    }

    public String algName() {
        return "HMAC-" + this.j.algName();
    }

    public int blockSize() {
        return this.i.blockSize();
    }

    public int getDigestLength() {
        return this.j.getDigestLength();
    }

    public byte[] getDigestBits() {
        return (byte[])this.a().clone();
    }

    byte[] a() {
        FIPS_140_2.assertReadyState();
        return this.m;
    }

    public boolean isValid() {
        return this.n;
    }

    public void erase() {
        this.c = null;
        if (this.d != null) {
            Utils.setArray(this.d, (byte)0);
            this.d = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    public Object clone() {
        HMAC hMAC = new HMAC(this.d, this.g, this.h);
        hMAC.i = (MessageDigest)this.i.clone();
        hMAC.j = (MessageDigest)this.j.clone();
        hMAC.k = (MessageDigest.MDState)this.k.clone();
        hMAC.l = (MessageDigest.MDState)this.l.clone();
        hMAC.e = (byte[])this.e.clone();
        hMAC.f = (byte[])this.f.clone();
        hMAC.m = (byte[])this.m.clone();
        hMAC.n = this.n;
        return hMAC;
    }

    protected MessageDigest.MDState b() {
        return null;
    }

    protected void a(MessageDigest.MDState mDState) {
        throw new RuntimeException("setState not valid for HMAC class");
    }
}

