/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.math.BigInteger;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.k;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.core.math.Prime;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.OIDManager;

public final class DiffieHellman {
    private BigInt a;
    private BigInt b;
    private BigInt c;
    private BigInt d;

    public DiffieHellman() {
    }

    public DiffieHellman(RandomBitsSource randomBitsSource, int n) throws IllegalArgumentException {
        this();
        this.initialize(randomBitsSource, n);
    }

    public DiffieHellman(BigInteger bigInteger, BigInteger bigInteger2, RandomBitsSource randomBitsSource) {
        this();
        this.initialize(bigInteger, bigInteger2, randomBitsSource);
    }

    public static DiffieHellman getInstance() throws AlgorithmIdentifierException {
        DiffieHellman diffieHellman;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(AlgID.dhKeyAgreement.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("DiffieHellman algID not found");
        }
        try {
            diffieHellman = (DiffieHellman)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement Cipher.");
        }
        return diffieHellman;
    }

    public static DiffieHellman getInstance(RandomBitsSource randomBitsSource, int n) throws IllegalArgumentException, AlgorithmIdentifierException {
        DiffieHellman diffieHellman = DiffieHellman.getInstance();
        diffieHellman.initialize(randomBitsSource, n);
        return diffieHellman;
    }

    public static DiffieHellman getInstance(BigInteger bigInteger, BigInteger bigInteger2, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        DiffieHellman diffieHellman = DiffieHellman.getInstance();
        diffieHellman.initialize(bigInteger, bigInteger2, randomBitsSource);
        return diffieHellman;
    }

    public void initialize(RandomBitsSource randomBitsSource, int n) {
        FIPS_140_2.assertReadyState();
        this.a(randomBitsSource, n);
        this.a(randomBitsSource);
    }

    public void initialize(BigInteger bigInteger, BigInteger bigInteger2, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.a = BigInt.getInstance(bigInteger);
        this.b = BigInt.getInstance(bigInteger2);
        this.a(randomBitsSource);
    }

    protected void a(RandomBitsSource randomBitsSource, int n) {
        BigInt bigInt;
        k.a(n, 4096);
        do {
            bigInt = Prime.generateBigIntPrime(n, randomBitsSource);
            this.a = bigInt.shiftLeft(1).add(BigInt.ONE);
        } while (!this.a.isProbablePrime(100));
        this.b = BigInt.valueOf(4L);
        bigInt.erase();
    }

    protected void a(RandomBitsSource randomBitsSource) {
        k.a(this.a.bitLength(), 4096);
        while (true) {
            this.c = randomBitsSource.randomBigInt(this.a.bitLength());
            if (this.c.compareTo(BigInt.ONE) <= 0 && this.c.compareTo(this.a) >= 0) continue;
            this.d = this.b.modPow(this.c, this.a);
            if (!this.d.equals(BigInt.ONE)) break;
        }
    }

    public BigInteger getPrime() {
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.a.toByteArray());
    }

    public BigInteger getGen() {
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.b.toByteArray());
    }

    public BigInteger myValue() {
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.d.toByteArray());
    }

    public BigInteger getKey(BigInteger bigInteger) {
        k.a(this.a.bitLength(), 4096);
        FIPS_140_2.assertReadyState();
        return new BigInteger(BigInt.getInstance(bigInteger).modPow(this.c, this.a).toByteArray());
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "p = " + this.a + ", g = " + this.b;
    }

    public void erase() {
        this.a = null;
        this.b = null;
        if (this.c != null) {
            this.c.erase();
            this.c = null;
        }
        if (this.d != null) {
            this.d.erase();
            this.d = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

