/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.c;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public abstract class BlockCipher
extends Cipher {
    protected byte[] a;
    private byte[] g;
    protected int b;
    protected Padding.ID c;

    protected BlockCipher() {
        this.b = 0;
        this.d = 0;
        this.c = Padding.NONE;
    }

    protected BlockCipher(int n) {
        this.b = n;
        this.d = 0;
        this.c = Padding.NONE;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        try {
            this.initialize(algorithmIdentifier, (SymmetricKey)key, Padding.NONE, randomBitsSource);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
    }

    public byte[] decrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        this.d();
        if (n2 % this.b != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        byte[] byArray2 = new byte[n2];
        this.decrypt(byArray, n, n2, byArray2, 0);
        if (bl) {
            return BlockCipher.a(this.c, this.b, byArray2);
        }
        return byArray2;
    }

    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.d();
        this.a(byArray, n, n2, byArray2, n3);
    }

    private void a(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        FIPS_140_2.assertReadyState();
        if (n2 % this.b != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        if (this.d == 0) {
            int n4 = n;
            int n5 = n3;
            while (n4 < n + n2) {
                this.a(byArray, n4, byArray2, n5);
                n4 += this.b;
                n5 += this.b;
            }
        } else {
            int n6 = n;
            int n7 = n3;
            while (n6 < n + n2) {
                this.a(byArray, n6, byArray2, n7);
                for (int i2 = 0; i2 < this.b; ++i2) {
                    int n8 = n7 + i2;
                    byArray2[n8] = (byte)(byArray2[n8] ^ this.g[i2]);
                }
                System.arraycopy(byArray, n6, this.g, 0, this.b);
                n6 += this.b;
                n7 += this.b;
            }
        }
    }

    protected abstract void a(byte[] var1, int var2, byte[] var3, int var4) throws CipherException;

    public byte[] encrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        this.e();
        if (bl) {
            byArray = BlockCipher.a(this.c, this.b, byArray, n, n2);
            n = 0;
            n2 = byArray.length;
        } else if (n2 % this.b != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        byte[] byArray2 = new byte[n2];
        this.encrypt(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.e();
        this.b(byArray, n, n2, byArray2, n3);
    }

    private void b(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        FIPS_140_2.assertReadyState();
        if (n2 % this.b != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        if (this.d == 0) {
            int n4 = n;
            int n5 = n3;
            while (n4 < n + n2) {
                this.b(byArray, n4, byArray2, n5);
                n4 += this.b;
                n5 += this.b;
            }
        } else {
            int n6 = n;
            int n7 = n3;
            while (n6 < n + n2) {
                for (int i2 = 0; i2 < this.b; ++i2) {
                    int n8 = i2;
                    this.g[n8] = (byte)(this.g[n8] ^ byArray[n6 + i2]);
                }
                this.b(this.g, 0, byArray2, n7);
                System.arraycopy(byArray2, n7, this.g, 0, this.b);
                n6 += this.b;
                n7 += this.b;
            }
        }
    }

    protected abstract void b(byte[] var1, int var2, byte[] var3, int var4) throws CipherException;

    public byte[] wrapKey(PrivateKey privateKey) throws CipherException {
        if (privateKey instanceof PrivateKeyPKCS8) {
            throw new CipherException("Cannot wrap encrypted key");
        }
        return this.b(oracle.security.crypto.core.c.a(privateKey));
    }

    public byte[] wrapKey(SymmetricKey symmetricKey) throws CipherException {
        return this.b(symmetricKey.d());
    }

    private byte[] b(byte[] byArray) throws CipherException {
        this.f();
        byte[] byArray2 = BlockCipher.a(this.c, this.b, byArray, 0, byArray.length);
        byte[] byArray3 = new byte[byArray2.length];
        this.b(byArray2, 0, byArray2.length, byArray3, 0);
        this.a();
        return byArray3;
    }

    public PrivateKey unwrapPrivateKey(byte[] byArray) throws CipherException {
        PrivateKey privateKey;
        byte[] byArray2 = this.c(byArray);
        try {
            privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        }
        catch (IOException iOException) {
            throw new CipherException(iOException.toString());
        }
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    public SymmetricKey unwrapSymmetricKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) throws CipherException {
        byte[] byArray2 = this.c(byArray);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2, algorithmIdentifier);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    private byte[] c(byte[] byArray) throws CipherException {
        this.g();
        byte[] byArray2 = new byte[byArray.length];
        this.a(byArray, 0, byArray.length, byArray2, 0);
        this.a();
        return BlockCipher.a(this.c, this.b, byArray2);
    }

    public void erase() {
        super.erase();
    }

    public final int getBlockSize() {
        return this.b;
    }

    public final byte[] getIV() {
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            return null;
        }
        return (byte[])this.a.clone();
    }

    protected void a(byte[] byArray) throws CipherException {
        if (byArray != null) {
            if (byArray.length != this.b) {
                throw new CipherException("IV length is not equal to block size");
            }
            this.a = (byte[])byArray.clone();
            if (this.g != null && this.g.length == this.b) {
                System.arraycopy(this.a, 0, this.g, 0, this.a.length);
            } else {
                this.g = (byte[])byArray.clone();
            }
        } else {
            this.a = null;
            this.g = null;
        }
        this.c();
    }

    public final Padding.ID getPaddingID() {
        return this.c;
    }

    final void a() {
        if (this.a != null && this.g != null) {
            System.arraycopy(this.a, 0, this.g, 0, this.a.length);
        }
    }

    static byte[] a(Padding.ID iD, int n, byte[] byArray, int n2, int n3) throws CipherException {
        if (iD == Padding.PKCS5) {
            if (n < 0 || n > 255) {
                throw new CipherException("Block size must be between 0 and 255");
            }
            byte by = (byte)(n - n3 % n);
            int n4 = n3 + by;
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            for (int i2 = n3; i2 < n4; ++i2) {
                byArray2[i2] = by;
            }
            return byArray2;
        }
        if (n3 % n == 0) {
            if (n2 == 0 && n3 == byArray.length) {
                return byArray;
            }
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n2, byArray3, 0, n3);
            return byArray3;
        }
        throw new CipherException("Data size is not a multiple of block size");
    }

    static byte[] a(Padding.ID iD, int n, byte[] byArray) throws CipherException {
        if (iD == Padding.PKCS5) {
            int n2 = byArray[byArray.length - 1] & 0xFF;
            if (n2 > n) {
                throw new CipherException("Invalid padding string (or incorrect password)");
            }
            int n3 = byArray.length;
            for (int i2 = byArray.length - n2; i2 < n3; ++i2) {
                if (byArray[i2] == n2) continue;
                throw new CipherException("Invalid padding string (or incorrect password)");
            }
            byte[] byArray2 = new byte[byArray.length - n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
        if (byArray.length % n == 0) {
            return byArray;
        }
        throw new CipherException("Data size is not a multiple of block size");
    }
}

