/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Constructed;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.asn1.a;
import oracle.security.crypto.fips.FIPS_140_2;

public class ASN1Set
implements ASN1TaggedObject,
ASN1Constructed {
    public static final int BER = 0;
    public static final int DER_SET = 1;
    public static final int DER_SET_OF = 2;
    private Vector a = new Vector();
    private int b = 0;
    private ASN1Header c = null;
    private int d = 2;
    private ASN1Object[] e = null;

    public ASN1Set() {
    }

    public ASN1Set(ASN1Object aSN1Object) {
        this.addElement(aSN1Object);
    }

    public ASN1Set(Vector vector) {
        this.a = vector;
        this.b = 0;
        int n = this.a.size();
        for (int i2 = 0; i2 < n; ++i2) {
            this.b += ((ASN1Object)this.a.elementAt(i2)).length();
        }
    }

    public ASN1Set(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addElement((ASN1Object)enumeration.nextElement());
        }
    }

    public ASN1Set(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1Header getHeader() {
        if (this.c == null) {
            this.c = new ASN1Header(17, 0, 1, this.b);
        }
        return this.c;
    }

    private ASN1Object[] a() {
        if (this.e == null) {
            this.e = ASN1Set.a(this.a, this.d);
        }
        return this.e;
    }

    public Vector elements() {
        return this.a;
    }

    public int size() {
        return this.a.size();
    }

    public ASN1Object elementAt(int n) {
        return (ASN1Object)this.a.elementAt(n);
    }

    public ASN1Object firstElement() {
        return (ASN1Object)this.a.firstElement();
    }

    public ASN1Object lastElement() {
        return (ASN1Object)this.a.lastElement();
    }

    public void addElement(ASN1Object aSN1Object) {
        this.a.addElement(aSN1Object);
        this.b += aSN1Object.length();
        this.c = null;
        this.e = null;
    }

    public void setEncodingType(int n) {
        this.d = n;
        this.e = null;
    }

    public int getEncodingType() {
        return this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET {");
        int n = this.a.size();
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(this.a.elementAt(i2).toString());
            if (i2 == this.a.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(inputStream);
        this.a = new Vector();
        this.b = 0;
        while (aSN1SetInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1SetInputStream);
            this.a.addElement(aSN1Object);
            this.b += aSN1Object.length();
        }
        aSN1SetInputStream.terminate();
        this.c = null;
        this.e = null;
    }

    public int length() {
        return this.getHeader().totalLength();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        if (this.d == 0) {
            int n = this.a.size();
            for (int i2 = 0; i2 < n; ++i2) {
                ((ASN1Object)this.a.elementAt(i2)).output(outputStream);
            }
        } else {
            ASN1Object[] aSN1ObjectArray = this.a();
            int n = aSN1ObjectArray.length;
            for (int i3 = 0; i3 < n; ++i3) {
                aSN1ObjectArray[i3].output(outputStream);
            }
        }
    }

    static ASN1Object[] a(Vector vector, int n) {
        ASN1Object[] aSN1ObjectArray = new ASN1Object[vector.size()];
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            aSN1ObjectArray[i2] = n == 2 ? new a((ASN1Object)vector.elementAt(i2)) : (ASN1Object)vector.elementAt(i2);
        }
        if (n != 0) {
            ASN1Set.a(aSN1ObjectArray, 0, aSN1ObjectArray.length - 1, n);
        }
        return aSN1ObjectArray;
    }

    private static void a(ASN1Object[] aSN1ObjectArray, int n, int n2, int n3) {
        if (n2 - n < 1 || n3 == 0) {
            return;
        }
        Random random = new Random();
        int n4 = n + (random.nextInt() & Integer.MAX_VALUE) % (n2 - n + 1);
        ASN1Object aSN1Object = aSN1ObjectArray[n4];
        aSN1ObjectArray[n4] = aSN1ObjectArray[n];
        aSN1ObjectArray[n] = aSN1Object;
        int n5 = n - 1;
        int n6 = n2 + 1;
        while (true) {
            if (ASN1Set.a(aSN1ObjectArray[++n5], aSN1Object, n3) < 0) {
                continue;
            }
            while (ASN1Set.a(aSN1ObjectArray[--n6], aSN1Object, n3) > 0) {
            }
            if (n5 >= n6) break;
            ASN1Object aSN1Object2 = aSN1ObjectArray[n5];
            aSN1ObjectArray[n5] = aSN1ObjectArray[n6];
            aSN1ObjectArray[n6] = aSN1Object2;
        }
        ASN1Set.a(aSN1ObjectArray, n, n6, n3);
        ASN1Set.a(aSN1ObjectArray, n6 + 1, n2, n3);
    }

    private static int a(ASN1Object aSN1Object, ASN1Object aSN1Object2, int n) {
        int n2;
        if (n == 1) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Object;
            ASN1TaggedObject aSN1TaggedObject2 = (ASN1TaggedObject)aSN1Object2;
            return aSN1TaggedObject.getHeader().getTag() - aSN1TaggedObject2.getHeader().getTag();
        }
        byte[] byArray = ((a)aSN1Object).a();
        byte[] byArray2 = ((a)aSN1Object2).a();
        int n3 = Math.min(byArray.length, byArray2.length);
        for (n2 = 0; n2 < n3 && byArray[n2] == byArray2[n2]; ++n2) {
        }
        if (n2 == n3) {
            return byArray.length - byArray2.length;
        }
        return (byArray[n2] & 0xFF) - (byArray2[n2] & 0xFF);
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

