/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class ASN1OctetString
implements ASN1TaggedObject {
    private ASN1Header a;
    private byte[] b;

    public ASN1OctetString(byte[] byArray) {
        this.a(byArray);
    }

    public ASN1OctetString(InputStream inputStream) throws IOException {
        this.a(ASN1OctetString.inputValue(inputStream));
    }

    private void a(byte[] byArray) {
        this.b = byArray;
        this.a = ASN1OctetString.makeHeader(byArray.length);
    }

    public ASN1Header getHeader() {
        return this.a;
    }

    public byte[] getValue() {
        return this.b;
    }

    public static ASN1Header makeHeader(int n) {
        return new ASN1Header(4, 0, 0, n);
    }

    public String toString() {
        return "OCTET STRING " + Utils.toHexString(this.b);
    }

    public void input(InputStream inputStream) throws IOException {
        this.a(ASN1OctetString.inputValue(inputStream));
    }

    public static byte[] inputValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(4);
        if (aSN1Header.getEncodingMethod() == 0) {
            return aSN1Header.readBody(inputStream);
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        while (aSN1ConstructedInputStream.hasMoreData()) {
            unsyncByteArrayOutputStream.write(ASN1OctetString.inputValue(aSN1ConstructedInputStream));
        }
        aSN1ConstructedInputStream.terminate();
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
        outputStream.write(this.b);
    }

    public int length() {
        return this.a.totalLength();
    }

    public static void outputValue(OutputStream outputStream, byte[] byArray) throws IOException {
        ASN1OctetString.a(outputStream, byArray, 4, 0);
    }

    public static void outputValue(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        ASN1OctetString.a(outputStream, byArray, n, n2, 4, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, byte[] byArray, int n) throws IOException {
        ASN1OctetString.a(outputStream, byArray, n, 128);
    }

    public static void outputValueWithTag(OutputStream outputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        ASN1OctetString.a(outputStream, byArray, n, n2, n3, 128);
    }

    private static void a(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        ASN1OctetString.a(outputStream, byArray, 0, byArray.length, n, n2);
    }

    private static void a(OutputStream outputStream, byte[] byArray, int n, int n2, int n3, int n4) throws IOException {
        outputStream.write(n4 + n3);
        ASN1Utils.outputLengthBytes(outputStream, n2);
        outputStream.write(byArray, n, n2);
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

