/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestSecurity;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.utils.RestTemplatePattern;
import oracle.dbtools.rest.utils.RestUtils;

public class RestValidator {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final List<String> IMPLICIT_BIND_PARAMETERS = new ArrayList<String>();
    private ArrayList<String> _messages;
    private String _moduleName;
    private String _templateURI;

    public boolean isValidRESTfulServices(List<RestModule> list, List<RestSecurity> list2) {
        this._messages = new ArrayList();
        this.validateRESTfulServices(list, list2);
        return this._messages.size() == 0;
    }

    public boolean isValidResourceModule(RestModule restModule) {
        this._messages = new ArrayList();
        this.validate(restModule);
        return this._messages.size() == 0;
    }

    public boolean isValidPrivilege(RestSecurity restSecurity) {
        this._messages = new ArrayList();
        this.validate(restSecurity);
        return this._messages.size() == 0;
    }

    private void validateRESTfulServices(List<RestModule> list, List<RestSecurity> list2) {
        if (list != null) {
            for (RestModule object : list) {
                this.validate(object);
            }
        }
        if (list2 != null) {
            for (RestSecurity restSecurity : list2) {
                this.validate(restSecurity);
            }
        }
    }

    private void validate(RestModule restModule) {
        this.validateModule(restModule);
        this._moduleName = restModule != null ? restModule.getName() : "";
        List<RestTemplate> list = restModule.getTemplates();
        if (list != null) {
            for (RestTemplate restTemplate : restModule.getTemplates()) {
                this._templateURI = restTemplate != null ? restTemplate.getURIPattern() : "";
                this.validateTemplates(restTemplate);
                HashMap<RestResourceHandler.HTTP_METHOD_TYPE, RestResourceHandler> hashMap = restTemplate.getResourceHandlers();
                for (RestResourceHandler.HTTP_METHOD_TYPE hTTP_METHOD_TYPE : hashMap.keySet()) {
                    RestResourceHandler restResourceHandler = hashMap.get((Object)hTTP_METHOD_TYPE);
                    this.validateHandlers(restResourceHandler);
                }
            }
        }
    }

    private void validate(RestSecurity restSecurity) {
        this.validatePrivilege(restSecurity);
    }

    private void validatePrivilege(RestSecurity restSecurity) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = restSecurity.getName();
        if (RestUtils.emptyValue(string)) {
            arrayList.add(RestArb.format("ERROR_VALUE_REQUIRED", RestArb.getString("LABEL_SEC_NAME")));
        }
        if (arrayList.size() > 0) {
            arrayList.add(0, this.getPrivilegeHeader(string));
            this.addErrorMessage(arrayList);
        }
    }

    private void validateModule(RestModule restModule) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = restModule.getName();
        String string2 = restModule.getURIPrefix();
        if (RestUtils.emptyValue(string)) {
            arrayList.add(RestArb.format("ERROR_VALUE_REQUIRED", RestArb.getString("LABEL_MODULE_NAME")));
        }
        if (!RestUtils.emptyValue(string2)) {
            try {
                new URI(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                arrayList.add(RestArb.format("ERROR_URI_SYNTAX", RestArb.getString("LABEL_URI_PREFIX")));
            }
        }
        if (arrayList.size() > 0) {
            arrayList.add(0, this.getHeader(this._moduleName, null, null));
            this.addErrorMessage(arrayList);
        }
    }

    private void validateTemplates(RestTemplate restTemplate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = restTemplate.getURIPattern();
        if (RestUtils.emptyValue(string)) {
            arrayList.add(RestArb.format("MISSING_URI", this._moduleName));
        } else if (RestTemplatePattern.isURITemplatePattern(string)) {
            if (!RestTemplatePattern.isValidURITemplate(string)) {
                arrayList.add(RestArb.format("URI_SYNTAX_ERROR", RestArb.getString("LABEL_URI_TEMPLATE")));
            }
        } else if (!RestTemplatePattern.isValidRoutePattern(string)) {
            arrayList.add(RestArb.format("URI_SYNTAX_ERROR", RestArb.getString("LABEL_ROUTE_PATTERN")));
        }
        if (arrayList.size() > 0) {
            arrayList.add(0, this.getHeader(this._moduleName, this._templateURI, null));
            this.addErrorMessage(arrayList);
        }
    }

    private void validateHandlers(RestResourceHandler restResourceHandler) {
        if (restResourceHandler == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.validateSQL(restResourceHandler, arrayList);
        this.validateHandlerParameters(restResourceHandler, arrayList);
        if (!arrayList.isEmpty()) {
            arrayList.add(0, this.getHeader(this._moduleName, this._templateURI, restResourceHandler.getMethodType().getNLS()));
            this.addErrorMessage(arrayList);
        }
    }

    private void validateSQL(RestResourceHandler restResourceHandler, List<String> list) {
        if (RestUtils.emptyValue(restResourceHandler.getSQL())) {
            if (restResourceHandler.getMethodType() == RestResourceHandler.HTTP_METHOD_TYPE.GET) {
                if (restResourceHandler.getSourceType() == RestResourceHandler.SOURCE_TYPE.PLSQL) {
                    list.add(RestArb.format("MISSING_STATEMENT", RestArb.getString("PL_SQL"), restResourceHandler.getMethodType().getNLS()));
                } else {
                    list.add(RestArb.format("MISSING_STATEMENT", RestArb.getString("QUERY"), restResourceHandler.getMethodType().getNLS()));
                }
            } else {
                list.add(RestArb.format("MISSING_PLSQL", new Object[]{restResourceHandler.getMethodType()}));
            }
        } else {
            this.checkSQLLegalForHandler(restResourceHandler, list);
        }
    }

    private void checkSQLLegalForHandler(RestResourceHandler restResourceHandler, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list2 = LexerToken.parse((String)restResourceHandler.getSQL(), (boolean)false);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = null;
        int n = 0;
        for (LexerToken lexerToken : list2) {
            if (lexerToken.type == Token.IDENTIFIER) {
                if (n == 0) {
                    if (restResourceHandler.getSourceType() == RestResourceHandler.SOURCE_TYPE.PLSQL) {
                        if (!lexerToken.content.equalsIgnoreCase("declare") && !lexerToken.content.equalsIgnoreCase("begin")) {
                            bl4 = true;
                            string = RestArb.format("INVALID_PLSQL_STMT", restResourceHandler.getMethodType().getNLS());
                            break;
                        }
                    } else if (!lexerToken.content.equalsIgnoreCase("select") && !lexerToken.content.equalsIgnoreCase("with")) {
                        bl4 = true;
                        string = RestArb.format("INVALID_QUERY_STMT", restResourceHandler.getSourceType().getNLS());
                        break;
                    }
                } else if (restResourceHandler.getSourceType() != RestResourceHandler.SOURCE_TYPE.PLSQL) {
                    if (lexerToken.content.equalsIgnoreCase("delete")) {
                        bl = true;
                    } else if (lexerToken.content.equalsIgnoreCase("update")) {
                        bl2 = true;
                    } else if (lexerToken.content.equalsIgnoreCase("insert")) {
                        bl3 = true;
                    }
                }
            }
            ++n;
        }
        if (bl4) {
            arrayList.add(string);
        } else {
            if (bl) {
                arrayList.add(RestArb.format("HANDLER_SQL_ERROR", RestArb.getString("DML_DELETE"), restResourceHandler.getMethodType().getNLS(), restResourceHandler.getSourceType().getNLS()));
            }
            if (bl2) {
                arrayList.add(RestArb.format("HANDLER_SQL_ERROR", RestArb.getString("DML_UPDATE"), restResourceHandler.getMethodType().getNLS(), restResourceHandler.getSourceType().getNLS()));
            }
            if (bl3) {
                arrayList.add(RestArb.format("HANDLER_SQL_ERROR", RestArb.getString("DML_INSERT"), restResourceHandler.getMethodType().getNLS(), restResourceHandler.getSourceType().getNLS()));
            }
        }
        if (arrayList.size() == 0) {
            SyntaxError syntaxError = null;
            syntaxError = restResourceHandler.getSourceType() == RestResourceHandler.SOURCE_TYPE.PLSQL ? SyntaxError.checkSyntax((String)restResourceHandler.getSQL(), (String[])new String[]{"sql_statements", "subprg_body"}) : SyntaxError.checkSQLQuerySyntax((String)restResourceHandler.getSQL());
            if (syntaxError != null) {
                arrayList.add(syntaxError.getDetailedMessage());
            }
        }
        if (arrayList.size() > 0) {
            list.addAll(arrayList);
        }
    }

    private void validateHandlerParameters(RestResourceHandler restResourceHandler, List<String> list) {
        String string;
        Iterator iterator;
        if (restResourceHandler == null || RestUtils.emptyValue(restResourceHandler.getSQL())) {
            return;
        }
        List<RestHandlerParameter> list2 = restResourceHandler.getParameters();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list2 != null && !list2.isEmpty()) {
            int n = 1;
            for (RestHandlerParameter object2 : list2) {
                String bl = object2.getName();
                Iterator iterator2 = object2.getBindVariable();
                if (RestUtils.emptyValue(bl)) {
                    list.add(RestArb.format("PARAM_MISSING_NAME", String.valueOf(n)));
                } else if (RestUtils.emptyValue((String)((Object)iterator2))) {
                    arrayList.add(bl);
                } else {
                    arrayList.add(iterator2);
                }
                ++n;
            }
        }
        String string3 = restResourceHandler.getSourceType() == RestResourceHandler.SOURCE_TYPE.PLSQL ? RestArb.getString("PL_SQL") : RestArb.getString("QUERY");
        List list3 = DBUtil.getBinds((String)restResourceHandler.getSQL());
        List<String> list4 = RestTemplatePattern.getParameters(this._templateURI);
        boolean bl = false;
        if (list4 != null && !list4.isEmpty()) {
            for (String string2 : list4) {
                bl = false;
                if (list3 != null && !list3.isEmpty()) {
                    iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        if (!string.equalsIgnoreCase(string2)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                list.add(RestArb.format("MISSING_BINDVAR_URIPARM", string2, restResourceHandler.getMethodType().getNLS(), string3));
            }
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            for (String string4 : arrayList) {
                bl = false;
                if (list3 != null && !list3.isEmpty()) {
                    iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        if (!string.equalsIgnoreCase(string4)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                list.add(RestArb.format("MISSING_BINDVAR_HANDLERPARAM", restResourceHandler.getMethodType().getNLS(), string4, string3));
            }
        }
    }

    private String getHeader(String string, String string2, String string3) {
        if (string != null && string2 != null && string3 != null) {
            return NEWLINE + RestArb.format("ERROR_HDR_MODULE_TEMPLATE_HANDLER", string, string2, string3) + NEWLINE;
        }
        if (string != null && string2 != null) {
            return NEWLINE + RestArb.format("ERROR_HDR_MODULE_TEMPLATE", string, string2) + NEWLINE;
        }
        if (string != null) {
            return NEWLINE + RestArb.format("ERROR_HDR_MODULE", string) + NEWLINE;
        }
        return NEWLINE + NEWLINE;
    }

    private String getPrivilegeHeader(String string) {
        if (string != null) {
            return NEWLINE + RestArb.format("ERROR_HDR_PRIVILEGE", string) + NEWLINE;
        }
        return NEWLINE + NEWLINE;
    }

    public String getErrorMessages() {
        if (this._messages != null && this._messages.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Calendar.getInstance().getTime()).append(NEWLINE);
            for (String string : this._messages) {
                stringBuilder.append(string).append(NEWLINE);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private void addErrorMessage(List<String> list) {
        if (this._messages == null) {
            this._messages = new ArrayList();
        }
        this._messages.addAll(list);
    }

    static {
        IMPLICIT_BIND_PARAMETERS.add("page_offset");
        IMPLICIT_BIND_PARAMETERS.add("page_size");
        IMPLICIT_BIND_PARAMETERS.add("row_count");
        IMPLICIT_BIND_PARAMETERS.add("row_offset");
        IMPLICIT_BIND_PARAMETERS.add("current_user");
        IMPLICIT_BIND_PARAMETERS.add("content_type");
        IMPLICIT_BIND_PARAMETERS.add("body");
    }
}

