/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.connection.RestConnection;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestSecurity;
import oracle.dbtools.rest.navigator.RestFolder;
import oracle.dbtools.rest.navigator.RestModuleFolder;
import oracle.dbtools.rest.navigator.RestModuleNode;
import oracle.dbtools.rest.navigator.RestRoot;
import oracle.dbtools.rest.navigator.RestTemplateNode;
import oracle.dbtools.rest.utils.RestXMLUtil;
import oracle.dbtools.util.Logger;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.WildcardURLFilter;

public class RestUtils {
    public static final WildcardURLFilter ZIP_FILTER = new WildcardURLFilter(RestArb.getString("ZIP_FILTER_MASK"), URLFileSystem.isLocalFileSystemCaseSensitive(), RestArb.getString("ZIP_FILTER_NAME"));
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static List<RestModule> getModules() {
        return RestRoot.getInstance().getModules();
    }

    public static List<RestSecurity> getPrivileges() {
        return RestRoot.getInstance().getPrivileges();
    }

    public static List<String> getRoles() {
        return RestRoot.getInstance().getRoles();
    }

    public static boolean loadAdmin(List<RestModule> list, List<RestSecurity> list2) {
        RestRoot.getInstance().loadData(list, list2);
        return true;
    }

    public static void loadRoles(List<String> list) {
        RestRoot.getInstance().loadRoles(list);
    }

    public static void loadSchemas(List<String> list) {
        RestRoot.getInstance().loadSchemas(list);
    }

    public static RestModuleNode createModuleNode(RestModule restModule) {
        return RestRoot.getInstance().createModuleNode(restModule);
    }

    public static List<String> getModuleNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<RestModule> list = RestUtils.getModules();
        if (list != null) {
            for (RestModule restModule : list) {
                String string2 = restModule.getName();
                if (string2 == null || string != null && string.equals(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static List<String> getPrivilegeNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<RestSecurity> list = RestUtils.getPrivileges();
        if (list != null) {
            for (RestSecurity restSecurity : list) {
                if (restSecurity.getName() == null || string != null && string.equals(restSecurity.getName())) continue;
                arrayList.add(restSecurity.getName());
            }
        }
        return arrayList;
    }

    public static List<String> getExistingURIs(RestFolder restFolder, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = restFolder.getChildren();
        if (iterator != null) {
            String string2 = null;
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                string2 = null;
                if (restFolder instanceof RestModuleFolder) {
                    string2 = ((RestModuleNode)((Object)iterator2.next())).getModule().getURIPrefix();
                } else if (restFolder instanceof RestModuleNode) {
                    string2 = ((RestTemplateNode)((Object)iterator2.next())).getTemplate().getURIPattern();
                }
                if (string2 == null || string != null && string.equals(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static boolean emptyValue(String string) {
        return string == null || string.isEmpty() || string.trim().length() == 0;
    }

    public static Charset getCharacterSet(String string) {
        Charset charset = null;
        if (string != null) {
            try {
                charset = Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                Logger.warn(RestXMLUtil.class, (String)RestArb.format("UNEXPECTED_CHARSET", string));
            }
        }
        if (charset == null) {
            try {
                charset = Charset.forName(DEFAULT_CHARSET);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                Logger.warn(RestXMLUtil.class, (String)RestArb.format("UNEXPECTED_CHARSET", DEFAULT_CHARSET));
                charset = Charset.defaultCharset();
            }
        }
        return charset;
    }

    public static URI getBaseURI() {
        if (RestConnection.getInstance().isConnectionOpen()) {
            return RestConnection.getInstance().getConnection().getDefaultServiceURI();
        }
        return null;
    }

    public static void setAPEXRestfulServices(boolean bl) {
        RestConnection.getInstance().setAPEXRestfulServices(bl);
    }

    public static boolean isAPEXRestfulServices() {
        return RestConnection.getInstance().isAPEXRestfulServices();
    }
}

