/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.patterns;

import java.util.ArrayDeque;
import java.util.Deque;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.rest.patterns.NamedPattern;
import oracle.dbtools.rest.patterns.PathToken;
import oracle.dbtools.rest.patterns.RoutePatternBase;
import oracle.dbtools.rest.patterns.RoutePatternBuilder;

abstract class PathTokenPattern
extends RoutePatternBase {
    protected final Iterable<PathToken> tokens;

    protected PathTokenPattern(Iterable<PathToken> iterable) {
        super(PathTokenPattern.canonicalExpansion(iterable));
        this.tokens = iterable;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('/');
        for (PathToken pathToken : this.tokens) {
            stringBuilder.append(pathToken);
        }
        return stringBuilder.toString();
    }

    private static char[] canonicalExpansion(Iterable<PathToken> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (PathToken pathToken : iterable) {
            switch (pathToken.type()) {
                case GLOB: {
                    stringBuilder.append(' ');
                    continue block4;
                }
                case PARAMETER: 
                case COMPOUND_PARAMETER: {
                    if (NamedPattern.Operator.EAGER == pathToken.operator()) {
                        stringBuilder.append('!');
                        continue block4;
                    }
                    if (NamedPattern.Operator.OPTIONAL == pathToken.operator()) {
                        stringBuilder.append('\"');
                        continue block4;
                    }
                    stringBuilder.append('#');
                    continue block4;
                }
            }
            stringBuilder.append(pathToken.toString());
        }
        return stringBuilder.toString().toCharArray();
    }

    static abstract class Builder
    implements RoutePatternBuilder {
        private final Deque<PathToken> tokens = new ArrayDeque<PathToken>();

        protected Builder() {
        }

        @Override
        public Builder addFile(CharSequence charSequence) {
            return this.add(PathToken.literal(charSequence.toString()));
        }

        @Override
        public Builder addFolder(CharSequence charSequence) {
            this.addFile(charSequence);
            return this.add(PathToken.separator());
        }

        public String toString() {
            return Iterables.join(this.tokens, (String)"");
        }

        protected final void expect(PathToken pathToken, PathToken.Type ... typeArray) {
            if (typeArray.length == 1 && null == typeArray[0]) {
                throw new IllegalStateException("Expected end of stream, but got: " + pathToken);
            }
            boolean bl = false;
            for (PathToken.Type type : typeArray) {
                if (type != pathToken.type()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalStateException("Expected: " + Iterables.join((Iterable)Iterables.iterable((Object[])typeArray), (String)", ") + " but got: " + pathToken);
            }
        }

        protected final Iterable<PathToken> tokens() {
            return Iterables.reverse(this.tokens);
        }

        protected abstract void validate(PathToken.Type var1, PathToken var2);

        final Builder add(PathToken pathToken) {
            PathToken.Type type = this.tokens.isEmpty() ? null : this.tokens.peek().type();
            this.validate(type, pathToken);
            this.tokens.push(pathToken);
            return this;
        }
    }
}

