/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.patterns;

import java.util.Map;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.ImmutableMultiMap;
import oracle.dbtools.common.immutables.Immutables;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.URLEncoding;
import oracle.dbtools.rest.patterns.NamedPattern;

class PathToken {
    private final Type type;
    private final Object value;
    private static final PathToken GLOB = new PathToken(Type.GLOB, null);
    private static final PathToken SEPARATOR = new PathToken(Type.SEPARATOR, null);

    private PathToken(Type type, Object object) {
        this.type = type;
        this.value = object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PathToken pathToken = (PathToken)object;
        if (this.type != pathToken.type) {
            return false;
        }
        return !(this.value == null ? pathToken.value != null : !this.value.equals(pathToken.value));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    public String toString() {
        switch (this.type) {
            case GLOB: {
                return "*";
            }
            case SEPARATOR: {
                return "/";
            }
            case LITERAL: {
                return (String)this.value;
            }
            case PARAMETER: {
                Pair pair = (Pair)this.value;
                String string = (String)pair.first();
                NamedPattern.Operator operator = (NamedPattern.Operator)((Object)pair.second());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(':');
                stringBuilder.append(string);
                if (operator != null) {
                    stringBuilder.append(operator.symbol());
                }
                return stringBuilder.toString();
            }
            case COMPOUND_PARAMETER: {
                Pair pair = (Pair)this.value;
                Iterable iterable = (Iterable)pair.first();
                NamedPattern.Operator operator = (NamedPattern.Operator)((Object)pair.second());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(':');
                stringBuilder.append(Iterables.join((Iterable)iterable, (String)","));
                if (operator != null) {
                    stringBuilder.append(operator.symbol());
                }
                return stringBuilder.toString();
            }
        }
        throw new IllegalStateException();
    }

    int decode(boolean bl, String string, int n, ImmutableMultiMap.Builder<String, String> builder) {
        int n2 = -1;
        if (this.endOfString(string, n)) {
            return -1;
        }
        switch (this.type) {
            case COMPOUND_PARAMETER: {
                n2 = this.decodeCompoundParameter(bl, string, n, builder);
                break;
            }
            case GLOB: {
                n2 = this.decodeGlob(bl, string, n, builder);
                break;
            }
            case LITERAL: {
                n2 = this.matchesLiteral(string, n);
                break;
            }
            case PARAMETER: {
                n2 = this.decodeParameter(bl, string, n, builder);
                break;
            }
            case SEPARATOR: {
                n2 = this.matchesSeparator(string, n);
            }
        }
        return n2;
    }

    int matches(String string, int n) {
        int n2 = -1;
        if (this.endOfString(string, n)) {
            return -1;
        }
        switch (this.type) {
            case COMPOUND_PARAMETER: {
                n2 = this.matchesCompoundParameter(string, n);
                break;
            }
            case GLOB: {
                n2 = this.matchesGlob(string, n);
                break;
            }
            case LITERAL: {
                n2 = this.matchesLiteral(string, n);
                break;
            }
            case PARAMETER: {
                n2 = this.matchesParameter(string, n);
                break;
            }
            case SEPARATOR: {
                n2 = this.matchesSeparator(string, n);
            }
        }
        return n2;
    }

    String name() {
        if (Type.PARAMETER.equals((Object)this.type)) {
            Pair pair = (Pair)this.value;
            return (String)pair.first();
        }
        throw new IllegalStateException(this.type.name());
    }

    Iterable<String> names() {
        if (Type.COMPOUND_PARAMETER.equals((Object)this.type)) {
            Pair pair = (Pair)this.value;
            return (Iterable)pair.first();
        }
        throw new IllegalStateException(this.type.name());
    }

    NamedPattern.Operator operator() {
        if (Type.PARAMETER.equals((Object)this.type)) {
            Pair pair = (Pair)this.value;
            return (NamedPattern.Operator)((Object)pair.second());
        }
        if (Type.COMPOUND_PARAMETER.equals((Object)this.type)) {
            Pair pair = (Pair)this.value;
            return (NamedPattern.Operator)((Object)pair.second());
        }
        throw new IllegalStateException(this.type.name());
    }

    Type type() {
        return this.type;
    }

    private int decodeCompoundParameter(boolean bl, String string, int n, ImmutableMultiMap.Builder<String, String> builder) {
        NamedPattern.Operator operator = this.operator();
        int n2 = -1;
        if (operator == null) {
            n2 = this.nextSeparator(string, n);
        } else if (NamedPattern.Operator.OPTIONAL == operator) {
            n2 = this.nextSeparator(string, n);
        } else if (NamedPattern.Operator.EAGER == operator) {
            n2 = string.length();
        }
        if (n2 == -1) {
            return -1;
        }
        String string2 = string.substring(n, n2);
        if (string2.isEmpty() && NamedPattern.Operator.OPTIONAL != operator) {
            return -1;
        }
        Map<String, String> map = this.parseCompoundParameter(string2);
        if (map == null) {
            return -1;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        return n2;
    }

    private int decodeGlob(boolean bl, String string, int n, ImmutableMultiMap.Builder<String, String> builder) {
        String string2 = string.substring(n);
        string2 = bl ? URLEncoding.decode((String)string2) : string2;
        builder.add((Object)"*", (Object)string2);
        return string.length();
    }

    private int decodeParameter(boolean bl, String string, int n, ImmutableMultiMap.Builder<String, String> builder) {
        NamedPattern.Operator operator = this.operator();
        int n2 = -1;
        if (operator == null) {
            n2 = this.nextSeparator(string, n);
        } else if (NamedPattern.Operator.OPTIONAL == operator) {
            n2 = this.nextSeparator(string, n);
        } else if (NamedPattern.Operator.EAGER == operator) {
            n2 = string.length();
        }
        if (n2 == -1) {
            return -1;
        }
        Pair pair = (Pair)this.value;
        String string2 = string.substring(n, n2);
        if (string2.isEmpty() && NamedPattern.Operator.OPTIONAL != operator) {
            return -1;
        }
        builder.add(pair.first(), (Object)string2);
        return n2;
    }

    private boolean endOfString(String string, int n) {
        boolean bl = Type.GLOB == this.type;
        boolean bl2 = (Type.COMPOUND_PARAMETER == this.type || Type.PARAMETER == this.type) && NamedPattern.Operator.OPTIONAL == this.operator();
        return !bl && !bl2 && n >= string.length();
    }

    private int matchesCompoundParameter(String string, int n) {
        NamedPattern.Operator operator = this.operator();
        int n2 = -1;
        n2 = NamedPattern.Operator.EAGER == operator ? string.length() : this.nextSeparator(string, n);
        if (n2 == -1) {
            return -1;
        }
        String string2 = string.substring(n, n2);
        if (string2.isEmpty() && NamedPattern.Operator.OPTIONAL != operator) {
            return -1;
        }
        Map<String, String> map = this.parseCompoundParameter(string2);
        if (map == null) {
            return -1;
        }
        return n2;
    }

    private int matchesGlob(String string, int n) {
        return string.length();
    }

    private int matchesLiteral(String string, int n) {
        int n2 = this.nextSeparator(string, n);
        if (n2 == -1) {
            return -1;
        }
        String string2 = (String)this.value;
        String string3 = string.substring(n, n2);
        String string4 = URLEncoding.decode((String)string3);
        return string2.equals(string4) ? n2 : -1;
    }

    private int matchesParameter(String string, int n) {
        NamedPattern.Operator operator = this.operator();
        if (operator == null) {
            int n2 = this.nextSeparator(string, n);
            if (n2 == n) {
                return -1;
            }
            return n2;
        }
        if (NamedPattern.Operator.OPTIONAL == operator) {
            int n3 = this.nextSeparator(string, n);
            return n3;
        }
        return string.length();
    }

    private int matchesSeparator(String string, int n) {
        char c = string.charAt(n);
        if ('/' == c) {
            return n + 1;
        }
        return -1;
    }

    private int nextSeparator(String string, int n) {
        int n2 = string.indexOf(47, n);
        if (n2 == -1) {
            return string.length();
        }
        return n2;
    }

    private Map<String, String> parseCompoundParameter(String string) {
        ImmutableMap.Builder builder = Immutables.maps().builder();
        Iterable<String> iterable = this.names();
        String[] stringArray = string.split(",");
        int n = 0;
        for (String string2 : iterable) {
            String string3;
            String string4 = string3 = n < stringArray.length ? stringArray[n] : null;
            if (NullOrEmpty.nullOrEmpty((CharSequence)string3)) {
                string3 = null;
            }
            builder.add((Object)string2, (Object)string3);
            ++n;
        }
        if (stringArray.length > n) {
            return null;
        }
        return builder.build();
    }

    static PathToken compoundParameter(Iterable<String> iterable, NamedPattern.Operator operator) {
        return new PathToken(Type.COMPOUND_PARAMETER, Pair.pair(iterable, (Object)((Object)operator)));
    }

    static PathToken glob() {
        return GLOB;
    }

    static PathToken literal(String string) {
        return new PathToken(Type.LITERAL, string);
    }

    static PathToken parameter(String string, NamedPattern.Operator operator) {
        return new PathToken(Type.PARAMETER, Pair.pair((Object)string, (Object)((Object)operator)));
    }

    static PathToken separator() {
        return SEPARATOR;
    }

    static enum Type {
        COMPOUND_PARAMETER,
        GLOB,
        LITERAL,
        PARAMETER,
        SEPARATOR;

    }
}

