/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.patterns;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import oracle.dbtools.rest.patterns.PathToken;

abstract class ParserBase {
    protected final PushbackReader r;
    private PathToken previous;

    public ParserBase(Reader reader) {
        this.r = new PushbackReader(reader, 2);
    }

    protected void addLiteral(StringBuilder stringBuilder, char c) {
        if (!this.isLegal(c)) {
            throw this.error("" + c, "literal");
        }
        stringBuilder.append(c);
    }

    protected PathToken eos() throws IOException {
        int n = this.r.read();
        if (n == -1) {
            return null;
        }
        throw this.error("" + (char)n, "eos");
    }

    protected RuntimeException error(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder("Expected one of: <<");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(">> but got: <<");
        stringBuilder.append(string);
        stringBuilder.append(">>");
        return new IllegalStateException(stringBuilder.toString());
    }

    protected PathToken literal() throws IOException {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        while (!bl) {
            int n = this.r.read();
            if (n == -1) {
                bl = true;
                continue;
            }
            char c = (char)n;
            if ('/' == c) {
                bl = true;
                this.r.unread(n);
                continue;
            }
            this.addLiteral(stringBuilder, c);
        }
        String string = stringBuilder.toString();
        if (string.isEmpty()) {
            return null;
        }
        return PathToken.literal(string);
    }

    protected abstract PathToken next();

    protected PathToken previous() {
        return this.previous;
    }

    protected void previous(PathToken pathToken) {
        this.previous = pathToken;
    }

    protected PathToken.Type previousType() {
        return this.previous == null ? null : this.previous.type();
    }

    protected PathToken separator() throws IOException {
        int n = this.r.read();
        if (n == -1) {
            return null;
        }
        char c = (char)n;
        if ('/' == c) {
            return PathToken.separator();
        }
        throw this.error("" + c, "/");
    }

    private boolean isLegal(char c) {
        return !this.isReserved(c) && this.isPrintable(c);
    }

    private boolean isPrintable(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && unicodeBlock != null && unicodeBlock != Character.UnicodeBlock.SPECIALS;
    }

    private boolean isReserved(char c) {
        return ":/?#[]@!$&'()*+,;=".indexOf(c) != -1;
    }
}

