/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.navigator;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.navigator.RestHandlerNode;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;

public class RestHandlerEditorNode
extends DefaultContainer
implements Observer {
    public static final int REST_NODE_CHANGED_MESSAGE_ID = UpdateMessage.newMessageID((String)(RestHandlerEditorNode.class.getName() + ".restNodeChanged"));
    public static final int REST_NODE_MODIFIED_MESSAGE_ID = UpdateMessage.newMessageID((String)(RestHandlerEditorNode.class.getName() + ".restNodeModified"));
    private static int _nodeId = 0;
    private RestHandlerNode _node;

    public RestHandlerEditorNode(RestHandlerNode restHandlerNode) {
        this._node = restHandlerNode;
        this.createURL();
        this.getAttributes().set(ElementAttributes.CLOSEABLE);
    }

    public RestHandlerNode getHandlerNode() {
        return this._node;
    }

    public void setHandlerNode(RestHandlerNode restHandlerNode) {
        this._node = restHandlerNode;
    }

    private void createURL() {
        URL uRL = URLFactory.newURL((String)"sqldev.rest", (String)("RestHandlerEditorNode/" + _nodeId++));
        this.setURL(uRL);
    }

    private String formatLabel(String string) {
        String string2 = this._node.getTemplateURI() != null ? this._node.getTemplateURI() : RestArb.getString("UNKNOWN_NODE");
        String string3 = string + " " + string2;
        if (string3.length() > 30) {
            return string3.substring(0, 30) + RestArb.getString("ELLIPSIS");
        }
        return string3;
    }

    public String getShortLabel() {
        return this._node == null ? "" : this.formatLabel(this._node.getShortLabel());
    }

    public String getLongLabel() {
        String string = this._node.getTemplateURI() != null ? this._node.getTemplateURI() : RestArb.getString("UNKNOWN_NODE");
        return this._node.getShortLabel() + string;
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public Icon getIcon() {
        return this._node == null ? null : this._node.getIcon();
    }

    protected void openImpl() throws IOException {
        if (this._node != null) {
            this._node.open();
        }
    }

    protected void closeImpl() throws IOException {
        if (this._node != null) {
            this._node.close();
            this._node = null;
        }
    }

    public void setViewedObject(RestHandlerNode restHandlerNode) {
        this._node = restHandlerNode;
        if (this._node != null) {
            this.ensureOpen();
            this.createURL();
        } else {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.notifyObservers((Object)this, new UpdateMessage(REST_NODE_CHANGED_MESSAGE_ID, (Object)this));
        this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
        this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.OBJECT_RELOADED, (Object)this));
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            this.notifyObservers(object, new UpdateMessage(REST_NODE_MODIFIED_MESSAGE_ID, (Object)this));
        }
    }
}

