/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;

public class InstallWizTablespacePanel
extends DefaultTraversablePanel {
    private JComboBox<String> m_defTblSpace1 = new JComboBox();
    private JComboBox<String> m_tmpTblSpace1 = new JComboBox();
    private JComboBox<String> m_defTblSpace2 = new JComboBox();
    private JComboBox<String> m_tmpTblSpace2 = new JComboBox();
    private RestInstallConstants.InstallType m_installType;
    private String m_installer;
    private String m_prevConnInfo = "";
    private String m_defValue_defTbs1 = "SYSAUX";
    private String m_defValue_tmpTbs1 = "TEMP";
    private String m_defValue_defTbs2 = "USERS";
    private String m_defValue_tmpTbs2 = "TEMP";
    private boolean m_canMigrateAPEXRest;
    private boolean m_init;

    public InstallWizTablespacePanel() {
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.m_defTblSpace1.setModel(new DefaultComboBoxModel<String>(new String[]{this.m_defValue_defTbs1}));
        this.m_tmpTblSpace1.setModel(new DefaultComboBoxModel<String>(new String[]{this.m_defValue_tmpTbs1}));
        this.m_defTblSpace2.setModel(new DefaultComboBoxModel<String>(new String[]{this.m_defValue_defTbs2}));
        this.m_tmpTblSpace2.setModel(new DefaultComboBoxModel<String>(new String[]{this.m_defValue_tmpTbs2}));
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, this.m_defTblSpace1, (String)RestArb.getString("DEFAULT_TABLESPACE"));
        ResourceUtils.resLabel((JLabel)jLabel2, this.m_tmpTblSpace1, (String)RestArb.getString("TEMP_TABLESPACE"));
        ResourceUtils.resLabel((JLabel)jLabel3, this.m_defTblSpace2, (String)RestArb.getString("DEFAULT_TABLESPACE"));
        ResourceUtils.resLabel((JLabel)jLabel4, this.m_tmpTblSpace2, (String)RestArb.getString("TEMP_TABLESPACE"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString("WIZ_NOT_EXIST_SCHEMA_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        Font font = jTextPane.getFont();
        jTextPane.setFont(font.deriveFont(font.getStyle() | 1, font.getSize()));
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setText(RestArb.getString("WIZ_CREATE_SCHEMA_DESCRIP"));
        jTextPane2.setEditable(false);
        jTextPane2.setOpaque(false);
        jTextPane2.setRequestFocusEnabled(false);
        jTextPane2.setFocusable(false);
        JTextPane jTextPane3 = new JTextPane();
        jTextPane3.setText(RestArb.format("WIZ_SELECT_TBS", RestArb.getString("WIZ_TBS_METADATA")));
        jTextPane3.setEditable(false);
        jTextPane3.setOpaque(false);
        jTextPane3.setRequestFocusEnabled(false);
        jTextPane3.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane3, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add(this.m_defTblSpace1, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add(this.m_tmpTblSpace1, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        LayoutControl.GBC.addHSpring((JPanel)jPanel, (int)2);
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("TABLESPACE"), (Component)jPanel);
        JTextPane jTextPane4 = new JTextPane();
        jTextPane4.setText(RestArb.format("WIZ_SELECT_TBS", RestArb.getString("WIZ_TBS_USER")));
        jTextPane4.setEditable(false);
        jTextPane4.setOpaque(false);
        jTextPane4.setRequestFocusEnabled(false);
        jTextPane4.setFocusable(false);
        n = 0;
        JPanel jPanel3 = LayoutControl.GBC.createPanel();
        jPanel3.add((Component)jTextPane4, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add(this.m_defTblSpace2, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)jLabel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add(this.m_tmpTblSpace2, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        LayoutControl.GBC.addHSpring((JPanel)jPanel3, (int)2);
        LayoutControl.GBC.addVSpring((JPanel)jPanel3, (int)(++n));
        JPanel jPanel4 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("TABLESPACE"), (Component)jPanel3);
        n = 0;
        this.add(jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jTextPane2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
    }

    private void initTablespace(final String string, final String string2, final String string3) {
        final WaitCursor waitCursor = new WaitCursor((Component)((Object)this));
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(RestArb.getString("LOAD_TABLESPACES"), true, IRaptorTaskRunMode.MODAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                try {
                    String string4 = string2;
                    String string22 = string3;
                    if (!string4.toUpperCase().equals("SYSTEM") && !string4.toUpperCase().contains(" AS SYSDBA")) {
                        string4 = string4 + " AS SYSDBA";
                    }
                    if (string22 != null && string3.startsWith("@")) {
                        string22 = string22.substring(1);
                        string22 = Passwords.comingIn((String)string22);
                    }
                    Connection connection = null;
                    try {
                        connection = DriverManager.getConnection(string, string4, string22);
                        final List list = InstallWizTablespacePanel.this.getTablespaceNames(connection, "select tablespace_name from dba_tablespaces order by 1");
                        final List list2 = InstallWizTablespacePanel.this.getTablespaceNames(connection, "select distinct(tablespace_name) from dba_temp_files order by 1");
                        connection.close();
                        final String[] stringArray = new String[list.size()];
                        list.toArray(stringArray);
                        final String[] stringArray2 = new String[list2.size()];
                        list2.toArray(stringArray2);
                        InstallWizTablespacePanel.this.m_prevConnInfo = string + string2;
                        string22 = null;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                InstallWizTablespacePanel.this.m_defTblSpace1.setModel(new DefaultComboBoxModel<String>(stringArray));
                                if (list.contains(InstallWizTablespacePanel.this.m_defValue_defTbs1)) {
                                    InstallWizTablespacePanel.this.m_defTblSpace1.setSelectedItem(InstallWizTablespacePanel.this.m_defValue_defTbs1);
                                }
                                InstallWizTablespacePanel.this.m_tmpTblSpace1.setModel(new DefaultComboBoxModel<String>(stringArray2));
                                if (list2.contains(InstallWizTablespacePanel.this.m_defValue_tmpTbs1)) {
                                    InstallWizTablespacePanel.this.m_tmpTblSpace1.setSelectedItem(InstallWizTablespacePanel.this.m_defValue_tmpTbs1);
                                }
                                InstallWizTablespacePanel.this.m_defTblSpace2.setModel(new DefaultComboBoxModel<String>(stringArray));
                                if (list.contains(InstallWizTablespacePanel.this.m_defValue_defTbs2)) {
                                    InstallWizTablespacePanel.this.m_defTblSpace2.setSelectedItem(InstallWizTablespacePanel.this.m_defValue_defTbs2);
                                }
                                InstallWizTablespacePanel.this.m_tmpTblSpace2.setModel(new DefaultComboBoxModel<String>(stringArray2));
                                if (list2.contains(InstallWizTablespacePanel.this.m_defValue_tmpTbs2)) {
                                    InstallWizTablespacePanel.this.m_tmpTblSpace2.setSelectedItem(InstallWizTablespacePanel.this.m_defValue_tmpTbs2);
                                }
                                InstallWizTablespacePanel.this.validate();
                                InstallWizTablespacePanel.this.repaint();
                            }
                        });
                    }
                    finally {
                        try {
                            if (connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable;
                Throwable throwable2 = raptorTaskEvent.getThrowable();
                while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                    throwable2 = throwable;
                }
                ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                this.cleanup();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            private void cleanup() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitCursor.hide();
                    }
                });
            }
        });
        waitCursor.show();
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private List<String> getTablespaceNames(Connection connection, String string) {
        return InstallDBUtils.getNames(connection, string);
    }

    private void validateValues() throws TraversalException {
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1) {
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            String string = (String)map2.get("db.url");
            String string2 = (String)map2.get("sys.user");
            String string3 = (String)map2.get("sys.password");
            String string4 = string + string2;
            if (string4.equals(this.m_prevConnInfo) && this.m_defTblSpace1.getModel() != null && this.m_defTblSpace1.getModel().getSize() > 0) {
                this.m_init = false;
                return;
            }
            this.m_init = true;
            if (map2.get("schema.tablespace.default") != null) {
                this.m_defValue_defTbs1 = (String)map2.get("schema.tablespace.default");
            }
            if (map2.get("schema.tablespace.temp") != null) {
                this.m_defValue_tmpTbs1 = (String)map2.get("schema.tablespace.temp");
            }
            if (map2.get("user.tablespace.default") != null) {
                this.m_defValue_defTbs2 = (String)map2.get("user.tablespace.default");
            }
            if (map2.get("user.tablespace.temp") != null) {
                this.m_defValue_tmpTbs2 = (String)map2.get("user.tablespace.temp");
            }
            this.initTablespace(string, string2, string3);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateValues();
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            this.m_installType = (RestInstallConstants.InstallType)((Object)map.get("config.status"));
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            this.m_installer = (String)map2.get("installer");
            map2.put("schema.tablespace.default", (String)this.m_defTblSpace1.getSelectedItem());
            map2.put("schema.tablespace.temp", (String)this.m_tmpTblSpace1.getSelectedItem());
            map2.put("user.tablespace.default", (String)this.m_defTblSpace2.getSelectedItem());
            map2.put("user.tablespace.temp", (String)this.m_tmpTblSpace2.getSelectedItem());
            if (this.m_init) {
                this.m_canMigrateAPEXRest = false;
                if (this.m_installer.equals("install") && (this.m_installType == RestInstallConstants.InstallType.MIGRATE_V2 || this.m_installType == RestInstallConstants.InstallType.VERIFY_SCHEMA)) {
                    this.m_canMigrateAPEXRest = InstallDBUtils.canMigrateAPEXRest((String)map2.get("db.url"), InstallDBUtils.getDBAUsername((String)map2.get("sys.user")), (String)map2.get("sys.password"));
                }
            }
        }
    }

    public Object getExitTransition() {
        switch (this.m_installType) {
            case REQUIRES_CONFIG: {
                return "Transition.PLSQLGateway";
            }
            case MIGRATE_V2: {
                if (this.m_installer.equals("install") && this.m_canMigrateAPEXRest) {
                    return "Transition.Migrate";
                }
                return "Transition.Standalone";
            }
            case MIGRATE_V1: {
                break;
            }
            case VERIFY_SCHEMA: {
                if (this.m_installer.equals("install") && this.m_canMigrateAPEXRest) {
                    return "Transition.Migrate";
                }
                return "Transition.Standalone";
            }
        }
        return "Transition.Standalone";
    }
}

