/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install;

import java.util.Map;
import oracle.dbtools.rest.install.InstallORDS;
import oracle.dbtools.rest.install.wizard.RestInstallWizard;
import oracle.dbtools.rest.install.wizard.RestUninstallWizard;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;

public class RestInstallController
implements Controller {
    private static final String INSTALL_CMD = "rest.INSTALL";
    private static final String UNINSTALL_CMD = "rest.UNINSTALL";
    private static final String RUN_STANDALONE_CMD = "rest.RUN.STANDALONE";
    public static final int INSTALL_CMD_ID = Ide.findOrCreateCmdID((String)"rest.INSTALL");
    public static final int RUN_STANDALONE_CMD_ID = Ide.findOrCreateCmdID((String)"rest.RUN.STANDALONE");
    public static final int UNINSTALL_CMD_ID = Ide.findOrCreateCmdID((String)"rest.UNINSTALL");

    private void installORDS(int n) {
        Map<String, Object> map = RestInstallWizard.ORDSInstallWizard(n);
        if (map != null) {
            InstallORDS.executeInstall(map);
        }
    }

    private void uninstallORDS(int n) {
        Map<String, Object> map = RestUninstallWizard.ORDSUninstallWizard(n);
        if (map != null) {
            InstallORDS.executeUninstall(map);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == INSTALL_CMD_ID || n == RUN_STANDALONE_CMD_ID) {
            this.installORDS(n);
            return true;
        }
        if (n == UNINSTALL_CMD_ID) {
            this.uninstallORDS(n);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == INSTALL_CMD_ID || n == RUN_STANDALONE_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == UNINSTALL_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }
}

