/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.editor;

import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public abstract class RestEditor
extends Editor {
    public static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"rest.PIN");
    private IdeAction _pinAction;
    private boolean _pinned = false;

    public RestEditor() {
        this.init();
    }

    private void init() {
        this.setEditorAttribute("scrollable", Boolean.FALSE);
    }

    public boolean isPinned() {
        return this._pinned;
    }

    private void setPinned(boolean bl) {
        this._pinned = bl;
    }

    protected IdeAction getPinAction() {
        if (this._pinAction == null) {
            this.createPinAction();
        }
        return this._pinAction;
    }

    private void createPinAction() {
        this.setPinned(false);
        this._pinAction = IdeAction.get((int)PIN_EDITOR_CMD_ID).newLocalAction((View)this);
        this._pinAction.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"pin.png"));
        this._pinAction.setState(this.isPinned());
        this._pinAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                int n = ideAction.getCommandId();
                if (PIN_EDITOR_CMD_ID == n) {
                    RestEditor.this.setPinned(!RestEditor.this.isPinned());
                    ideAction.setState(RestEditor.this.isPinned());
                    if (!RestEditor.this.isPinned()) {
                        ideAction.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"pin.png"));
                    } else {
                        ideAction.putValue("SmallIcon", (Object)RaptorImagesArb.getIcon((String)"PINNED"));
                    }
                    return true;
                }
                return false;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
    }

    public Node getNode() {
        return this.getContext().getNode();
    }

    public void open() {
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }
}

