/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.dbtools.autorest.model.RestObjectData;
import oracle.dbtools.autorest.ui.RestObjectOperationsPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class RestWizObjectOperationsPanel
extends DefaultTraversablePanel {
    private RestObjectOperationsPanel objectOperationsPanel;
    private transient RestObjectData objectDataModel;
    private GridBagLayout gridBagLayout = new GridBagLayout();

    private void jbInit(TraversableContext traversableContext) {
        this.setName("RestWizObjectOperationsPanel");
        this.objectDataModel = (RestObjectData)traversableContext.get("KEY_REST_OBJECT_DATA");
        this.objectOperationsPanel = new RestObjectOperationsPanel(this.objectDataModel);
        this.setLayout(this.gridBagLayout);
        this.add(this.objectOperationsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this.objectOperationsPanel == null) {
            this.jbInit(traversableContext);
        } else {
            this.objectOperationsPanel.addListeners();
            this.objectOperationsPanel.updatePanel();
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1 && this.objectOperationsPanel != null) {
            if (!this.objectOperationsPanel.validInfo()) {
                throw new TraversalException(this.objectOperationsPanel.getErrorMessage());
            }
            this.objectDataModel = this.objectOperationsPanel.getValues();
            traversableContext.put("KEY_REST_OBJECT_DATA", (Object)this.objectDataModel);
            this.objectOperationsPanel.removeListeners();
        }
    }

    public Object getExitTransition() {
        return "Transition.Finish";
    }
}

