/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.model.RestObjectData;
import oracle.dbtools.autorest.ui.CheckBoxColumnHeaderRenderer;
import oracle.dbtools.autorest.ui.CheckBoxTableCellRendererEditor;
import oracle.dbtools.autorest.ui.LabelColumnHeaderRenderer;

public class RestObjectOperationsPanel
extends JPanel {
    public static final String PANEL_OBJECT_OPERATIONS_HEADER_OPERATION = AutoRestArb.get("PANEL_OBJECT_OPERATIONS_HEADER_OPERATION");
    public static final String PANEL_OBJECT_OPERATIONS_HEADER_ALLOWED = AutoRestArb.get("PANEL_OBJECT_OPERATIONS_HEADER_ALLOWED");
    private transient RestObjectData objectDataModel;
    private List<String> existingNames;
    private ArrayList<String> _errMsg;
    private transient ObjectDataModelListener objectDataModelListener = new ObjectDataModelListener();
    private ArrayList<String> ignorePropertyList = new ArrayList();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JScrollPane operationsAllowedScrollPane = new JScrollPane();
    private JTable operationsAllowedTable = new JTable();
    private OperationsAllowedTableModel operationsAllowedTableModel = new OperationsAllowedTableModel();
    private JCheckBox useDefaultCheckBox = new JCheckBox();

    public RestObjectOperationsPanel(RestObjectData restObjectData) {
        this.objectDataModel = restObjectData;
        this.objectDataModel.addPropertyChangeListener(this.objectDataModelListener);
        this.jbInit();
    }

    private void jbInit() {
        this.initialise();
        this.setName("RestObjectOperationsPanel");
        this.setLayout(this.gridBagLayout1);
        this.operationsAllowedTable.setName("operationsAllowedTable");
        this.operationsAllowedTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.operationsAllowedTable.setModel(this.operationsAllowedTableModel);
        this.useDefaultCheckBox.setName("useDefaultCheckBox");
        this.useDefaultCheckBox.setText(AutoRestArb.get("PANEL_OPERATIONS_USE_SCHEMA_DEFAULT"));
        this.useDefaultCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RestObjectOperationsPanel.this.useDefaultCheckBox_actionPerformed(actionEvent);
            }
        });
        this.operationsAllowedScrollPane.setName("operationsAllowedScrollPane");
        this.operationsAllowedTable.getColumnModel().getColumn(0).setHeaderRenderer(new LabelColumnHeaderRenderer());
        this.operationsAllowedTable.getColumnModel().getColumn(1).setCellRenderer(new CheckBoxTableCellRendererEditor());
        this.operationsAllowedTable.getColumnModel().getColumn(1).setCellEditor(new CheckBoxTableCellRendererEditor());
        this.operationsAllowedTable.getColumnModel().getColumn(1).setHeaderRenderer(new CheckBoxColumnHeaderRenderer());
        this.operationsAllowedScrollPane.getViewport().add((Component)this.operationsAllowedTable, null);
        this.add((Component)this.operationsAllowedScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.useDefaultCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    public void addListeners() {
    }

    public void removeListeners() {
    }

    public boolean validInfo() {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList();
        } else {
            this._errMsg.clear();
        }
        boolean bl = false;
        if (this._errMsg.size() > 0) {
            bl = true;
        }
        return this._errMsg.size() == 0;
    }

    public RestObjectData getValues() {
        return this.objectDataModel;
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    public void setExistingNames(List<String> list) {
        this.existingNames = list;
    }

    public boolean isExistModuleName(String string) {
        if (this.existingNames == null || this.existingNames.isEmpty()) {
            return false;
        }
        return this.existingNames.contains(string);
    }

    private void initialise() {
        if (this.objectDataModel != null) {
            this.operationsAllowedTableModel.fireTableDataChanged();
            this.useDefaultCheckBox.getModel().setSelected(this.objectDataModel.isAllowedSchemaDefault());
            this.operationsAllowedTable.setEnabled(!this.objectDataModel.isAllowedSchemaDefault());
        }
    }

    public void updatePanel() {
        this.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void useDefaultCheckBox_actionPerformed(ActionEvent actionEvent) {
        ArrayList<String> arrayList = this.ignorePropertyList;
        synchronized (arrayList) {
            if (!this.ignorePropertyList.contains("allowedSchemaDefault")) {
                try {
                    this.ignorePropertyList.add("allowedSchemaDefault");
                    this.objectDataModel.setAllowedSchemaDefault(this.useDefaultCheckBox.isSelected());
                    this.operationsAllowedTable.setEnabled(!this.useDefaultCheckBox.isSelected());
                    this.operationsAllowedTable.invalidate();
                    this.operationsAllowedTable.repaint();
                }
                finally {
                    this.ignorePropertyList.remove("allowedSchemaDefault");
                }
            }
        }
    }

    private class ObjectDataModelListener
    implements PropertyChangeListener {
        private ObjectDataModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            ArrayList arrayList = RestObjectOperationsPanel.this.ignorePropertyList;
            synchronized (arrayList) {
                if (!RestObjectOperationsPanel.this.ignorePropertyList.contains(string)) {
                    if (propertyChangeEvent.getPropertyName().equals("operations") || propertyChangeEvent.getPropertyName().equals("allowed")) {
                        RestObjectOperationsPanel.this.operationsAllowedTableModel.fireTableDataChanged();
                    } else if (propertyChangeEvent.getPropertyName().equals("allowedSchemaDefault")) {
                        boolean bl = RestObjectOperationsPanel.this.objectDataModel.isAllowedSchemaDefault();
                        RestObjectOperationsPanel.this.useDefaultCheckBox.getModel().setSelected(bl);
                        RestObjectOperationsPanel.this.operationsAllowedTable.setEnabled(!bl);
                        RestObjectOperationsPanel.this.operationsAllowedTable.invalidate();
                        RestObjectOperationsPanel.this.operationsAllowedTable.repaint();
                    }
                }
            }
        }
    }

    private class OperationsAllowedTableModel
    extends AbstractTableModel {
        protected Vector columnIdentifiers = new Vector();

        public OperationsAllowedTableModel() {
            this.addColumn(PANEL_OBJECT_OPERATIONS_HEADER_OPERATION);
            this.addColumn(PANEL_OBJECT_OPERATIONS_HEADER_ALLOWED);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            switch (n2) {
                case 0: {
                    object = RestObjectOperationsPanel.this.objectDataModel.getOperations()[n];
                    break;
                }
                case 1: {
                    object = RestObjectOperationsPanel.this.objectDataModel.getAllowed()[n];
                }
            }
            return object;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    ((RestObjectOperationsPanel)RestObjectOperationsPanel.this).objectDataModel.getOperations()[n] = object == null ? null : object.toString();
                    break;
                }
                case 1: {
                    ((RestObjectOperationsPanel)RestObjectOperationsPanel.this).objectDataModel.getAllowed()[n] = object == null ? null : (object instanceof Boolean ? (Boolean)object : Boolean.valueOf(object.toString()));
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public int getColumnCount() {
            int n = 2;
            return n;
        }

        @Override
        public int getRowCount() {
            int n = RestObjectOperationsPanel.this.objectDataModel.getOperations().length;
            return n;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public int findColumn(String string) {
            boolean bl = false;
            if (string != null) {
                if (string.equals(PANEL_OBJECT_OPERATIONS_HEADER_OPERATION)) {
                    bl = false;
                } else if (string.equals(PANEL_OBJECT_OPERATIONS_HEADER_ALLOWED)) {
                    bl = true;
                }
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            String string = PANEL_OBJECT_OPERATIONS_HEADER_OPERATION;
            switch (n) {
                case 0: {
                    string = PANEL_OBJECT_OPERATIONS_HEADER_OPERATION;
                    break;
                }
                case 1: {
                    string = PANEL_OBJECT_OPERATIONS_HEADER_ALLOWED;
                }
            }
            return string;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Class clazz = String.class;
            switch (n) {
                case 0: {
                    clazz = String.class;
                    break;
                }
                case 1: {
                    clazz = Boolean.class;
                }
            }
            return clazz;
        }

        public void addColumn(Object object) {
            this.columnIdentifiers.addElement(object);
            this.fireTableStructureChanged();
        }
    }
}

