/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import oracle.spatial.util.ByteOrder;
import oracle.spatial.util.GeometryExceptionWithContext;
import oracle.spatial.util.Logger;
import oracle.spatial.util.WKAdapter;
import oracle.spatial.util.WKBasis;
import oracle.spatial.util.WKInputStream;

public class WKT
extends WKBasis
implements WKAdapter {
    private static Logger logger = Logger.getLogger("oracle.spatial.util.WKT");

    @Override
    protected void writeByteOrder(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
    }

    protected void write(DataOutputStream dataOutputStream, String string) throws GeometryExceptionWithContext {
        try {
            dataOutputStream.writeBytes(string);
        }
        catch (IOException iOException) {
            throw new GeometryExceptionWithContext(null, "IOException: " + iOException.toString(), null);
        }
    }

    @Override
    protected void writeBeginningOfList(ByteOrder byteOrder, DataOutputStream dataOutputStream, int n) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, "(");
    }

    @Override
    protected void writeBeginningOfList(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, "(");
    }

    @Override
    protected void writeGeometrySeparator(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, ", ");
    }

    @Override
    protected void writeCoordPairSeparator(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, ", ");
    }

    @Override
    protected void writeXYSeparator(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, " ");
    }

    @Override
    protected void writeEndOfList(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, ")");
    }

    @Override
    protected void writeByte(DataOutputStream dataOutputStream, int n) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, "" + n);
    }

    @Override
    protected void writeDouble(ByteOrder byteOrder, DataOutputStream dataOutputStream, double d) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, "" + d);
    }

    @Override
    protected void writeLabel(DataOutputStream dataOutputStream, int n, int n2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        Object var5_5 = null;
        switch (n) {
            case 1: {
                if (n2 == 4) break;
                this.write(dataOutputStream, "POINT ");
                break;
            }
            case 2: {
                if (n2 == 5 || n2 == 1000004) break;
                this.write(dataOutputStream, "LINESTRING ");
                break;
            }
            case 1000001: {
                this.write(dataOutputStream, "CIRCULARSTRING ");
                break;
            }
            case 1000002: {
                this.write(dataOutputStream, "COMPOUNDCURVE ");
                break;
            }
            case 3: {
                if (n2 == 6) break;
                this.write(dataOutputStream, "POLYGON ");
                break;
            }
            case 1000003: {
                if (n2 == 1000005) break;
                this.write(dataOutputStream, "CURVEPOLYGON ");
                break;
            }
            case 4: {
                this.write(dataOutputStream, "MULTIPOINT ");
                break;
            }
            case 1000004: {
                this.write(dataOutputStream, "MULTICURVE ");
                break;
            }
            case 5: {
                this.write(dataOutputStream, "MULTILINESTRING ");
                break;
            }
            case 1000005: {
                this.write(dataOutputStream, "MULTISURFACE ");
                break;
            }
            case 6: {
                this.write(dataOutputStream, "MULTIPOLYGON ");
                break;
            }
            case 7: {
                this.write(dataOutputStream, "GEOMETRYCOLLECTION ");
                break;
            }
            case 21: {
                this.write(dataOutputStream, "NURBSCURVE ");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Override
    protected void writeInnerLabel(DataOutputStream dataOutputStream, int n, int n2) throws GeometryExceptionWithContext {
        Object var4_4 = null;
        switch (n) {
            case 91: {
                this.write(dataOutputStream, "DEGREE ");
                break;
            }
            case 92: {
                this.write(dataOutputStream, "CONTROLPOINTS ");
                break;
            }
            case 93: {
                this.write(dataOutputStream, "NURBSPOINT ");
                break;
            }
            case 94: {
                this.write(dataOutputStream, "WEIGHTEDPOINT ");
                break;
            }
            case 95: {
                this.write(dataOutputStream, "WEIGHT ");
                break;
            }
            case 96: {
                this.write(dataOutputStream, "KNOTS ");
                break;
            }
            case 97: {
                this.write(dataOutputStream, "KNOT ");
                break;
            }
            case 98: {
                this.write(dataOutputStream, "VALUE ");
                break;
            }
            case 99: {
                this.write(dataOutputStream, "MULTIPLICITY ");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Override
    protected WKInputStream getWKInputStream(byte[] byArray) {
        return new WKTInputStream(byArray);
    }

    protected class WKTInputStream
    implements WKInputStream {
        protected final StreamTokenizer m_tokenizer;
        protected final Vector[] m_listLengths;
        protected int m_currentParanLevel;
        protected int[] dimension = new int[1];

        public WKTInputStream(byte[] byArray) {
            this.m_tokenizer = this.tokenizeWKT(new String(byArray));
            this.m_listLengths = this.readListLengths(this.tokenizeWKT(new String(byArray)), this.dimension);
            this.m_currentParanLevel = 0;
        }

        @Override
        public int getDimensions() {
            return this.dimension[0];
        }

        @Override
        public double readDouble(ByteOrder byteOrder) {
            try {
                if (this.m_tokenizer.nextToken() != -2) {
                    throw new RuntimeException("Token type " + this.m_tokenizer.ttype + ": " + this.m_tokenizer.sval);
                }
                double d = this.m_tokenizer.nval;
                if (this.m_tokenizer.nextToken() != -3) {
                    this.m_tokenizer.pushBack();
                } else if (this.m_tokenizer.sval.toUpperCase().startsWith("E")) {
                    d = Double.parseDouble(d + this.m_tokenizer.sval);
                } else {
                    throw new RuntimeException("Token(s) " + d + this.m_tokenizer.sval + " unexpected.");
                }
                return d;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException();
            }
        }

        @Override
        public int readLabel(ByteOrder byteOrder, int n) {
            switch (n) {
                case 4: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 3;
                }
                case 21: {
                    return 21;
                }
                case 1000002: 
                case 1000003: 
                case 1000004: {
                    try {
                        switch (this.m_tokenizer.nextToken()) {
                            case 40: {
                                this.m_tokenizer.pushBack();
                                return 2;
                            }
                        }
                        String string = this.m_tokenizer.sval;
                        if (string.equalsIgnoreCase("LINESTRING")) {
                            return 2;
                        }
                        if (string.equalsIgnoreCase("CIRCULARSTRING")) {
                            return 1000001;
                        }
                        if (string.equalsIgnoreCase("COMPOUNDCURVE")) {
                            return 1000002;
                        }
                        if (string.equalsIgnoreCase("NURBSCURVE")) {
                            return 21;
                        }
                        throw new RuntimeException();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("" + this.m_tokenizer.ttype + " ");
                    }
                }
            }
            try {
                if (this.m_tokenizer.nextToken() != -3) {
                    throw new RuntimeException();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("" + this.m_tokenizer.ttype + " ");
            }
            String string = this.m_tokenizer.sval;
            if (string.equalsIgnoreCase("POINT")) {
                return 1;
            }
            if (string.equalsIgnoreCase("LINESTRING")) {
                return 2;
            }
            if (string.equalsIgnoreCase("CIRCULARSTRING")) {
                return 1000001;
            }
            if (string.equalsIgnoreCase("COMPOUNDCURVE")) {
                return 1000002;
            }
            if (string.equalsIgnoreCase("POLYGON")) {
                return 3;
            }
            if (string.equalsIgnoreCase("CURVEPOLYGON")) {
                return 1000003;
            }
            if (string.equalsIgnoreCase("MULTIPOINT")) {
                return 4;
            }
            if (string.equalsIgnoreCase("MULTICURVE")) {
                return 1000004;
            }
            if (string.equalsIgnoreCase("MULTILINESTRING")) {
                return 5;
            }
            if (string.equalsIgnoreCase("MULTISURFACE")) {
                return 1000005;
            }
            if (string.equalsIgnoreCase("MULTIPOLYGON")) {
                return 6;
            }
            if (string.equalsIgnoreCase("GEOMETRYCOLLECTION")) {
                return 7;
            }
            if (string.equalsIgnoreCase("NURBSCURVE")) {
                return 21;
            }
            throw new RuntimeException();
        }

        @Override
        public int readInnerLabel() {
            int n = 0;
            try {
                n = this.m_tokenizer.nextToken();
                if (n != 44 && n != 41 && n != -3) {
                    throw new RuntimeException();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("" + this.m_tokenizer.ttype + " ");
            }
            if (n != -3) {
                return n;
            }
            String string = this.m_tokenizer.sval;
            if (string.equalsIgnoreCase("DEGREE")) {
                return 91;
            }
            if (string.equalsIgnoreCase("CONTROLPOINTS")) {
                return 92;
            }
            if (string.equalsIgnoreCase("NURBSPOINT")) {
                return 93;
            }
            if (string.equalsIgnoreCase("WEIGHTEDPOINT")) {
                return 94;
            }
            if (string.equalsIgnoreCase("WEIGHT")) {
                return 95;
            }
            if (string.equalsIgnoreCase("KNOTS")) {
                return 96;
            }
            if (string.equalsIgnoreCase("KNOT")) {
                return 97;
            }
            if (string.equalsIgnoreCase("VALUE")) {
                return 98;
            }
            if (string.equalsIgnoreCase("MULTIPLICITY")) {
                return 99;
            }
            throw new RuntimeException();
        }

        @Override
        public void readStartList() {
            try {
                if (this.m_tokenizer.nextToken() != 40) {
                    throw new RuntimeException("" + this.m_tokenizer.ttype);
                }
                ((Integer)this.m_listLengths[this.m_currentParanLevel++].remove(0)).intValue();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException();
            }
        }

        @Override
        public int readStartList(ByteOrder byteOrder) throws RuntimeException {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                if (this.m_tokenizer.nextToken() != 40) {
                    throw new RuntimeException("Opening parentheses missing " + this.m_tokenizer.ttype);
                }
                int n = (Integer)this.m_listLengths[this.m_currentParanLevel++].remove(0);
                return n;
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
                String string = stringWriter.toString();
                throw new RuntimeException(string);
            }
            finally {
                try {
                    if (printWriter != null) {
                        printWriter.close();
                        printWriter = null;
                    }
                    if (stringWriter != null) {
                        stringWriter.close();
                        stringWriter = null;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException(iOException.getMessage());
                }
            }
        }

        protected Vector[] readListLengths(StreamTokenizer streamTokenizer, int[] nArray) {
            Vector[] vectorArray = new Vector[10];
            for (int i = 0; i < 10; ++i) {
                vectorArray[i] = new Vector();
            }
            try {
                int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                int n = 0;
                int n2 = 0;
                boolean bl = false;
                streamTokenizer.nextToken();
                do {
                    int n3;
                    if ((n3 = streamTokenizer.nextToken()) == -1 && n != 0) {
                        throw new RuntimeException("Missing opening or closing parenthesis");
                    }
                    switch (n3) {
                        case 40: {
                            nArray2[n] = 1;
                            ++n;
                            break;
                        }
                        case 41: {
                            vectorArray[--n].add(new Integer(nArray2[n]));
                            if (bl) break;
                            nArray[0] = n2;
                            bl = true;
                            break;
                        }
                        case 44: {
                            int n4 = n - 1;
                            nArray2[n4] = nArray2[n4] + 1;
                            if (bl) break;
                            nArray[0] = n2;
                            bl = true;
                            break;
                        }
                        case -2: {
                            ++n2;
                        }
                    }
                } while (n > 0);
                return vectorArray;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException();
            }
        }

        @Override
        public void readEndList() {
            --this.m_currentParanLevel;
            try {
                if (this.m_tokenizer.nextToken() != 41) {
                    throw new RuntimeException();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("" + this.m_tokenizer.ttype);
            }
        }

        @Override
        public void readEndListOrSeparator() {
            try {
                int n = this.m_tokenizer.nextToken();
                if (n != 41 && n != 44) {
                    throw new RuntimeException();
                }
                if (n == 41) {
                    --this.m_currentParanLevel;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("" + this.m_tokenizer.ttype);
            }
        }

        @Override
        public void readSeparator() {
            try {
                if (this.m_tokenizer.nextToken() != 44) {
                    throw new RuntimeException();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("" + this.m_tokenizer.ttype);
            }
        }

        @Override
        public int readByte() throws GeometryExceptionWithContext {
            return -1;
        }

        @Override
        public ByteOrder readByteOrder() throws GeometryExceptionWithContext {
            return ByteOrder.BIG_ENDIAN;
        }

        protected StreamTokenizer tokenizeWKT(String string) {
            StringReader stringReader = new StringReader(string);
            StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.lowerCaseMode(true);
            streamTokenizer.parseNumbers();
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            return streamTokenizer;
        }
    }
}

