/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.controls.display.IDisplayDetail;
import oracle.dbtools.raptor.controls.display.IDisplayDetailPanelManager;
import oracle.dbtools.raptor.controls.display.IPanelManagerContext;
import oracle.dbtools.raptor.report.ui.ChildNode;
import oracle.dbtools.raptor.report.ui.PropertyDetailNode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportTreeContext;
import oracle.dbtools.raptor.report.ui.ReportTreeNode;
import oracle.dbtools.raptor.report.ui.ReportTreePanel;

public class PropertyNode
extends ReportTreeNode {
    public static final String LABEL = ReportArb.getString("PROPERTY_NODE");
    private Map<String, JPanel> panelMap = new HashMap<String, JPanel>();
    private String dbName;

    public PropertyNode(ReportTreeContext reportTreeContext) {
        super(reportTreeContext);
        this.repopulateDetailNodes();
        this.context().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("STYLE")) {
                    PropertyNode.this.repopulateDetailNodes();
                }
            }
        });
    }

    @Override
    public String typeLabel() {
        return LABEL;
    }

    public void setDbName(String string) {
        this.dbName = string;
        HashSet<IDisplayDetailPanelManager> hashSet = new HashSet<IDisplayDetailPanelManager>();
        for (JPanel jPanel : this.panelMap.values()) {
            IDisplayDetailPanelManager iDisplayDetailPanelManager;
            if (!(jPanel instanceof IDisplayDetailPanelManager) || !hashSet.add(iDisplayDetailPanelManager = (IDisplayDetailPanelManager)jPanel)) continue;
            iDisplayDetailPanelManager.setDbName(string);
        }
    }

    @Override
    protected void cleanup() {
        HashSet<IDisplayDetailPanelManager> hashSet = new HashSet<IDisplayDetailPanelManager>();
        for (JPanel jPanel : this.panelMap.values()) {
            IDisplayDetailPanelManager iDisplayDetailPanelManager;
            if (!(jPanel instanceof IDisplayDetailPanelManager) || !hashSet.add(iDisplayDetailPanelManager = (IDisplayDetailPanelManager)jPanel)) continue;
            iDisplayDetailPanelManager.close();
        }
    }

    @Override
    public JPanel panel() {
        String string = this.context().style();
        JPanel jPanel = this.panelMap.get(string);
        if (jPanel == null) {
            if (DisplayRegistry.hasDetails((String)string).booleanValue()) {
                IDisplayDetail iDisplayDetail = null;
                try {
                    iDisplayDetail = DisplayRegistry.getDetailPanel((String)string);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                if (iDisplayDetail != null) {
                    DisplayModel displayModel = this.context().model();
                    if (displayModel != null && displayModel.getExtValues() != null && !displayModel.getExtValues().isEmpty()) {
                        iDisplayDetail.setValues(displayModel.getExtValues());
                    }
                    if (iDisplayDetail instanceof IDisplayDetailPanelManager) {
                        IDisplayDetailPanelManager iDisplayDetailPanelManager = (IDisplayDetailPanelManager)iDisplayDetail;
                        iDisplayDetailPanelManager.setPanelManagerContext(new IPanelManagerContext(){

                            public DisplayPanel getLiveDisplayPanel(Object object) {
                                ChildNode childNode = PropertyNode.this.context().owningChildNode();
                                return PropertyNode.this.context().treePanel().createDisplayPanel(object, true, childNode, true);
                            }

                            public void retrieveAllSQLColumnNames(PropertyChangeListener propertyChangeListener) {
                                ChildNode childNode = PropertyNode.this.context().owningChildNode();
                                ReportTreePanel reportTreePanel = PropertyNode.this.context().treePanel();
                                reportTreePanel.doRetrieveAllSQLColumnNames(childNode, propertyChangeListener);
                            }
                        });
                        iDisplayDetailPanelManager.setSubPanelsListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                PropertyNode.this.repopulateDetailNodes();
                            }
                        });
                        if (this.dbName != null && !this.dbName.equals("")) {
                            iDisplayDetailPanelManager.setDbName(this.dbName);
                        }
                    }
                    jPanel = (JPanel)iDisplayDetail;
                }
            }
            if (jPanel == null) {
                jPanel = new JPanel();
            }
            this.panelMap.put(string, jPanel);
        }
        return jPanel;
    }

    @Override
    public void onSelection() {
        JPanel jPanel = this.panel();
        if (jPanel instanceof IDisplayDetailPanelManager) {
            IDisplayDetailPanelManager iDisplayDetailPanelManager = (IDisplayDetailPanelManager)jPanel;
            iDisplayDetailPanelManager.setSelectedSubPanel(null);
        }
    }

    private void repopulateDetailNodes() {
        JPanel jPanel = this.panel();
        TreePath treePath = new TreePath(this.jNode().getPath());
        JTree jTree = this.context().treePanel().getReportTree();
        boolean bl = false;
        if (jTree != null) {
            bl = jTree.isExpanded(treePath);
            for (ReportTreeNode object : this.childNodes()) {
                object.remove();
            }
        }
        if (jPanel instanceof IDisplayDetailPanelManager) {
            IDisplayDetailPanelManager iDisplayDetailPanelManager = (IDisplayDetailPanelManager)jPanel;
            for (String string : iDisplayDetailPanelManager.getSubPanels()) {
                PropertyDetailNode propertyDetailNode = new PropertyDetailNode(this.context(), iDisplayDetailPanelManager, string);
                propertyDetailNode.insertAtTail(this);
                propertyDetailNode.setVisible(true);
            }
        }
        if (jTree != null) {
            if (bl) {
                jTree.expandPath(treePath);
            } else {
                jTree.collapsePath(treePath);
            }
        }
    }
}

