/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.report.pdf.IPDFOptions;
import oracle.dbtools.raptor.report.pdf.PDFBlobPanel;
import oracle.dbtools.raptor.report.pdf.PDFCellLayoutPanel;
import oracle.dbtools.raptor.report.pdf.PDFColumnLayoutPanel;
import oracle.dbtools.raptor.report.pdf.PDFDocumentPropertiesPanel;
import oracle.dbtools.raptor.report.pdf.PDFHeaderFooterPanel;
import oracle.dbtools.raptor.report.pdf.PDFPageSetupPanel;
import oracle.dbtools.raptor.report.pdf.PDFSecurityPanel;
import oracle.dbtools.raptor.report.pdf.PDFTableLayoutPanel;
import oracle.dbtools.raptor.report.ui.PDFDetailNode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportTreeContext;
import oracle.dbtools.raptor.report.ui.ReportTreeNode;

public class PDFNode
extends ReportTreeNode {
    public static final String LABEL = ReportArb.getString("PDF_NODE");
    private PDFDocumentPropertiesPanel panel;
    private JPanel jPanel;
    private PDFFormatOptions pdfFormatOptions;
    private PDFDetailNode blobNode;
    private PDFDetailNode cellLayoutNode;
    private PDFDetailNode columnLayoutNode;
    private PDFDetailNode tableNode;
    private PDFDetailNode headerFooterNode;
    private PDFDetailNode pageSetupNode;
    private PDFBlobPanel blobPanel;
    private PDFCellLayoutPanel cellLayoutPanel;
    private PDFColumnLayoutPanel columnLayoutPanel;
    private PDFTableLayoutPanel tablePanel;
    private PDFHeaderFooterPanel headerFooterPanel;
    private PDFSecurityPanel securityPanel;
    private PDFPageSetupPanel pageSetupPanel;

    public PDFNode(ReportTreeContext reportTreeContext) {
        super(reportTreeContext);
        DisplayModel displayModel = reportTreeContext.model();
        if (displayModel != null) {
            this.pdfFormatOptions = displayModel.getPDFFormatOptions();
        }
        if (this.pdfFormatOptions == null) {
            this.pdfFormatOptions = new PDFConfig().getPDFPreferences();
        }
        this.blobNode = new PDFDetailNode(this.context(), ReportArb.getString("BLOB_NODE")){

            @Override
            protected IPDFOptions createPanel() {
                PDFNode.this.blobPanel = new PDFBlobPanel();
                PDFNode.this.assignPDFFormatValues(PDFNode.this.blobPanel);
                return PDFNode.this.blobPanel;
            }
        };
        this.blobNode.insertAtTail(this);
        this.blobNode.setVisible(true);
        this.cellLayoutNode = new PDFDetailNode(this.context(), ReportArb.getString("CELL_LAYOUT_NODE")){

            @Override
            protected IPDFOptions createPanel() {
                PDFNode.this.cellLayoutPanel = new PDFCellLayoutPanel();
                PDFNode.this.assignPDFFormatValues(PDFNode.this.cellLayoutPanel);
                return PDFNode.this.cellLayoutPanel;
            }
        };
        this.cellLayoutNode.insertAtTail(this);
        this.cellLayoutNode.setVisible(true);
        this.columnLayoutNode = new PDFDetailNode(this.context(), ReportArb.getString("COLUMN_LAYOUT_NODE")){

            @Override
            protected IPDFOptions createPanel() {
                PDFNode.this.columnLayoutPanel = new PDFColumnLayoutPanel();
                PDFNode.this.assignPDFFormatValues(PDFNode.this.columnLayoutPanel);
                return PDFNode.this.columnLayoutPanel;
            }
        };
        this.columnLayoutNode.insertAtTail(this);
        this.columnLayoutNode.setVisible(true);
        this.tableNode = new PDFDetailNode(this.context(), ReportArb.getString("TABLE_LAYOUT_NODE")){

            @Override
            protected IPDFOptions createPanel() {
                PDFNode.this.tablePanel = new PDFTableLayoutPanel();
                PDFNode.this.assignPDFFormatValues(PDFNode.this.tablePanel);
                return PDFNode.this.tablePanel;
            }
        };
        this.tableNode.insertAtTail(this);
        this.tableNode.setVisible(true);
        this.headerFooterNode = new PDFDetailNode(this.context(), ReportArb.getString("HEADER_FOOTER_NODE")){

            @Override
            protected IPDFOptions createPanel() {
                PDFNode.this.headerFooterPanel = new PDFHeaderFooterPanel();
                PDFNode.this.assignPDFFormatValues(PDFNode.this.headerFooterPanel);
                return PDFNode.this.headerFooterPanel;
            }
        };
        this.headerFooterNode.insertAtTail(this);
        this.headerFooterNode.setVisible(true);
        this.pageSetupNode = new PDFDetailNode(this.context(), ReportArb.getString("PAGE_LAYOUT_NODE")){

            @Override
            protected IPDFOptions createPanel() {
                PDFNode.this.pageSetupPanel = new PDFPageSetupPanel();
                PDFNode.this.assignPDFFormatValues(PDFNode.this.pageSetupPanel);
                return PDFNode.this.pageSetupPanel;
            }
        };
        this.pageSetupNode.insertAtTail(this);
        this.pageSetupNode.setVisible(true);
    }

    @Override
    public String typeLabel() {
        return LABEL;
    }

    @Override
    public JPanel panel() {
        if (this.jPanel == null) {
            this.panel = new PDFDocumentPropertiesPanel();
            this.assignPDFFormatValues(this.panel);
            this.jPanel = this.panel.getPanel();
        }
        return this.jPanel;
    }

    public PDFFormatOptions pdfFormatOptions() {
        if (this.panel != null) {
            this.panel.getPDFFormatOptions();
        }
        if (this.blobPanel != null) {
            this.blobPanel.getPDFFormatOptions();
        }
        if (this.cellLayoutPanel != null) {
            this.cellLayoutPanel.getPDFFormatOptions();
        }
        if (this.columnLayoutPanel != null) {
            this.columnLayoutPanel.getPDFFormatOptions();
        }
        if (this.tablePanel != null) {
            this.tablePanel.getPDFFormatOptions();
        }
        if (this.headerFooterPanel != null) {
            this.headerFooterPanel.getPDFFormatOptions();
        }
        if (this.securityPanel != null) {
            this.securityPanel.getPDFFormatOptions();
        }
        if (this.pageSetupPanel != null) {
            this.pageSetupPanel.getPDFFormatOptions();
        }
        return this.pdfFormatOptions;
    }

    public PDFBlobPanel blobPanel() {
        return this.blobPanel;
    }

    public PDFCellLayoutPanel cellLayoutPanel() {
        return this.cellLayoutPanel;
    }

    public PDFColumnLayoutPanel columnLayoutPanel() {
        return this.columnLayoutPanel;
    }

    public PDFTableLayoutPanel tablePanel() {
        return this.tablePanel;
    }

    public PDFHeaderFooterPanel headerFooterPanel() {
        return this.headerFooterPanel;
    }

    public PDFSecurityPanel securityPanel() {
        return this.securityPanel;
    }

    public PDFPageSetupPanel pageSetupPanel() {
        return this.pageSetupPanel;
    }

    private void assignPDFFormatValues(IPDFOptions iPDFOptions) {
        DisplayModel displayModel = this.context().model();
        if (displayModel != null) {
            iPDFOptions.assignPDFFormatValues(this.pdfFormatOptions);
        }
    }
}

