/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.ReportAsianFonts;
import oracle.dbtools.raptor.format.ReportFormatOptions;
import oracle.dbtools.raptor.report.pdf.IPDFOptions;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.dbtools.raptor.report.pdf.PDFConstants;
import oracle.dbtools.raptor.report.pdf.PDFFontPanel;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.util.ResourceUtils;

public class PDFColumnLayoutPanel
implements IPDFOptions {
    private static final long serialVersionUID = 1L;
    private static final int FOOTINGS_LABELING_SIZE = 2;
    private static ReportFormatOptions.COLUMN_LABELING[] cl = ReportFormatOptions.COLUMN_LABELING.values();
    private PDFFormatOptions _pdfFormat = null;
    private PDFFontPanel _headerFontPanel = null;
    private CustomColorChoice _headerRowColorChoice = null;
    private JComboBox _headerLabeling = null;
    private PDFFontPanel _footerFontPanel = null;
    private CustomColorChoice _footerRowColorChoice = null;
    private JComboBox _footerLabeling = null;
    private int _row = 0;
    private int _col = 0;

    public PDFColumnLayoutPanel() {
        this.init();
    }

    private void init() {
        this._headerRowColorChoice = new CustomColorChoice();
        this._headerLabeling = new JComboBox<String>(PDFConstants.COLUMN_LABELING_LIST);
        this._footerRowColorChoice = new CustomColorChoice();
        this._footerLabeling = new JComboBox<String>(this.getFooterLabelingOptions());
    }

    @Override
    public JPanel getPanel() {
        if (this._pdfFormat == null) {
            this.assignPDFFormatValues(new PDFConfig().getPDFPreferences());
        }
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._headerRowColorChoice, (String)PDFArb.getString("HEADER_ROW_SHADING"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._headerLabeling, (String)PDFArb.getString("HEADER"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._footerRowColorChoice, (String)PDFArb.getString("FOOTER_ROW_SHADING"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._footerLabeling, (String)PDFArb.getString("FOOTER"));
        this._row = 0;
        this._col = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel2, new GridBagConstraints(this._col, this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 0, 8), 0, 0));
        jPanel.add((Component)this._headerLabeling, new GridBagConstraints(++this._col, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 6), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = this._headerFontPanel.getPanel();
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.5, 21, 2, new Insets(6, 6, 0, 8), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jLabel, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 0, 8), 0, 0));
        jPanel4.add((Component)this._headerRowColorChoice, new GridBagConstraints(1, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 6), 0, 0));
        jPanel4.add(Box.createGlue(), new GridBagConstraints(2, this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel4, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 2, new Insets(3, 6, 6, 8), 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel5.add((Component)jPanel, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 8, 0), 0, 0));
        jPanel5.add((Component)jPanel2, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)PDFArb.getString("COLUMN_HEADER_TITLE"));
        this._row = 0;
        this._col = 0;
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.add((Component)jLabel4, new GridBagConstraints(this._col, this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 0, 8), 0, 0));
        jPanel6.add((Component)this._footerLabeling, new GridBagConstraints(++this._col, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 6), 0, 0));
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        JPanel jPanel8 = this._footerFontPanel.getPanel();
        jPanel7.add((Component)jPanel8, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.5, 21, 2, new Insets(6, 6, 0, 8), 0, 0));
        JPanel jPanel9 = new JPanel(new GridBagLayout());
        jPanel9.add((Component)jLabel3, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 0, 8), 0, 0));
        jPanel9.add((Component)this._footerRowColorChoice, new GridBagConstraints(1, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 6), 0, 0));
        jPanel9.add(Box.createGlue(), new GridBagConstraints(2, this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel7.add((Component)jPanel9, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 2, new Insets(3, 6, 6, 8), 0, 0));
        JPanel jPanel10 = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel10.add((Component)jPanel6, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 8, 0), 0, 0));
        jPanel10.add((Component)jPanel7, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel7, (String)PDFArb.getString("COLUMN_FOOTER_TITLE"));
        this._row = 0;
        JPanel jPanel11 = new JPanel(new GridBagLayout());
        jPanel11.add((Component)jPanel5, new GridBagConstraints(0, this._row, 4, 1, 0.0, 0.0, 23, 0, new Insets(3, 0, 0, 0), 0, 0));
        jPanel11.add((Component)jPanel10, new GridBagConstraints(0, ++this._row, 4, 1, 0.0, 0.0, 23, 0, new Insets(15, 0, 0, 0), 0, 0));
        jPanel11.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 0, 0, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.enableDisableColumnHeadings();
        this.enableDisableColumnFootings();
        return jPanel11;
    }

    @Override
    public void assignPDFFormatValues(PDFFormatOptions pDFFormatOptions) {
        this._pdfFormat = pDFFormatOptions;
        this._headerFontPanel = new PDFFontPanel(this._pdfFormat.getHeaderFontName(), this._pdfFormat.getHeaderFontStyle(), this._pdfFormat.getHeaderFontSize(), this._pdfFormat.getHeaderFontColor(), this._pdfFormat.getFontLocations(), ReportAsianFonts.isVendorAsianJar((String)this._pdfFormat.getExternalLibrary()), 1);
        this._footerFontPanel = new PDFFontPanel(this._pdfFormat.getFooterFontName(), this._pdfFormat.getFooterFontStyle(), this._pdfFormat.getFooterFontSize(), this._pdfFormat.getFooterFontColor(), this._pdfFormat.getFontLocations(), ReportAsianFonts.isVendorAsianJar((String)this._pdfFormat.getExternalLibrary()), 2);
        Color color = new Color(this._pdfFormat.getHeaderRowShading());
        this._headerRowColorChoice.setSelectedColor(color);
        this._headerLabeling.setSelectedIndex(this._pdfFormat.getColumnHeadingsAction().ordinal());
        color = new Color(this._pdfFormat.getFooterRowShading());
        this._footerRowColorChoice.setSelectedColor(color);
        this._footerLabeling.setSelectedIndex(this._pdfFormat.getColumnFootingsAction().ordinal());
        this._headerLabeling.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PDFColumnLayoutPanel.this.enableDisableColumnHeadings();
            }
        });
        this._footerLabeling.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PDFColumnLayoutPanel.this.enableDisableColumnFootings();
            }
        });
    }

    @Override
    public PDFFormatOptions getPDFFormatOptions() {
        if (this._pdfFormat != null) {
            ReportFormatOptions.COLUMN_LABELING[] cOLUMN_LABELINGArray = ReportFormatOptions.COLUMN_LABELING.values();
            this._pdfFormat.setHeaderFontName(this._headerFontPanel.getFontName());
            this._pdfFormat.setHeaderFontStyle(this._headerFontPanel.getFontStyle());
            this._pdfFormat.setHeaderFontSize(this._headerFontPanel.getFontSize());
            this._pdfFormat.setHeaderFontColor(this._headerFontPanel.getFontColor());
            this._pdfFormat.setHeaderRowShading(this._headerRowColorChoice.getSelectedColor().getRGB());
            this._pdfFormat.setColumnHeadingsAction(cOLUMN_LABELINGArray[this._headerLabeling.getSelectedIndex()]);
            this._pdfFormat.setFooterFontName(this._footerFontPanel.getFontName());
            this._pdfFormat.setFooterFontStyle(this._footerFontPanel.getFontStyle());
            this._pdfFormat.setFooterFontSize(this._footerFontPanel.getFontSize());
            this._pdfFormat.setFooterFontColor(this._footerFontPanel.getFontColor());
            this._pdfFormat.setFooterRowShading(this._footerRowColorChoice.getSelectedColor().getRGB());
            this._pdfFormat.setColumnFootingsAction(cOLUMN_LABELINGArray[this._footerLabeling.getSelectedIndex()]);
        }
        return this._pdfFormat;
    }

    public boolean updateFontList(boolean bl) {
        boolean bl2 = this._headerFontPanel.setFontList(this._pdfFormat.getHeaderFontName(), this._pdfFormat.getFontLocations(), bl);
        bl2 = this._footerFontPanel.setFontList(this._pdfFormat.getFooterFontName(), this._pdfFormat.getFontLocations(), bl);
        return bl2;
    }

    private String[] getFooterLabelingOptions() {
        String[] stringArray = new String[2];
        for (int i = 0; i < 2; ++i) {
            stringArray[i] = PDFConstants.COLUMN_LABELING_LIST[i];
        }
        return stringArray;
    }

    private void enableDisableColumnHeadings() {
        boolean bl = cl[this._headerLabeling.getSelectedIndex()] != ReportFormatOptions.COLUMN_LABELING.NONE;
        this._headerFontPanel.setFontEnabled(bl);
        this._headerRowColorChoice.setEnabled(bl);
    }

    private void enableDisableColumnFootings() {
        boolean bl = cl[this._footerLabeling.getSelectedIndex()] != ReportFormatOptions.COLUMN_LABELING.NONE;
        this._footerFontPanel.setFontEnabled(bl);
        this._footerRowColorChoice.setEnabled(bl);
    }
}

