/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.addin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.ReportAsianFonts;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.dbtools.raptor.report.pdf.PDFDocumentPropertiesPanel;
import oracle.ide.controls.URLPathField;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class PDFPreferences
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private PDFDocumentPropertiesPanel _docPropertiesOptions = new PDFDocumentPropertiesPanel();
    private PDFConfig _pdfConfig = new PDFConfig();
    private int _row = 0;

    public PDFPreferences() {
        this.setHelpID("f1_dbPDFparam_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this._docPropertiesOptions.setUsePDFPreferences(true, (Component)((Object)this));
        this._docPropertiesOptions.assignPDFFormatValues(this._pdfConfig.getPDFPreferences());
        this.add(this._docPropertiesOptions.getPanel(), new GridBagConstraints(0, ++this._row, 5, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private boolean validateFontLocations() throws TraversalException {
        boolean bl = false;
        try {
            URLPath uRLPath = this._docPropertiesOptions.getFontPath();
            List list = uRLPath.asList();
            if (list != null && !list.isEmpty()) {
                for (URL uRL : list) {
                    if (URLFileSystem.isDirectory((URL)uRL)) continue;
                    String string = URLFileSystem.getPlatformPathName((URL)uRL);
                    throw new TraversalException(PDFArb.format("INVALID_PATH", PDFArb.getString("FONT_LOCATION_TITLE"), string), PDFArb.getString("INVALID_FONT_LOCATION_TITLE"));
                }
            }
            bl = true;
        }
        catch (URLPathField.BadEntryException badEntryException) {
            throw new TraversalException(PDFArb.format("MSG_BAD_ENTRY", badEntryException.getBadEntry()));
        }
        return bl;
    }

    private boolean validateExternalLibrary() throws TraversalException {
        URL uRL;
        String string = this._docPropertiesOptions.getExternalLibrary();
        if (string == null || string.isEmpty()) {
            return true;
        }
        File file = new File(string);
        if (!file.isFile() && !file.canRead()) {
            throw new TraversalException(PDFArb.format("MSG_BAD_ENTRY", string));
        }
        if (ReportAsianFonts.isVendorAsianJar((String)string) && (uRL = ((Object)((Object)this)).getClass().getResource("/com/itextpdf/text/pdf/fonts/cjkfonts.properties")) == null) {
            MessageDialog.information(null, (Object)ReportAsianFonts.asianJarCopyMessage((String)string), (String)PDFArb.getString("CJK_TITLE"), null);
        }
        return true;
    }

    public void onEntry(TraversableContext traversableContext) {
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.validateFontLocations() && this.validateExternalLibrary()) {
            this._pdfConfig.saveDocPropertiesPreferences(traversableContext, this._docPropertiesOptions.getPDFFormatOptions());
        }
    }
}

