/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.actions;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorContextMenu;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;

public class CreateReportActionProvider
implements ActionProvider<Object> {
    public static final String CREATE_REPORT = "create_report";
    private static final IdeAction CREATE_REPORT_ACTION;
    private List<WorksheetAction> m_actions;

    public CreateReportActionProvider() {
        WorksheetAction worksheetAction = WorksheetAction.createWorksheetAction((String)CREATE_REPORT, (WorksheetAction.ActionType)WorksheetAction.ActionType.CONTEXT_MENU_ONLY, (int)0, (double)0.0);
        this.m_actions = Collections.singletonList(worksheetAction);
    }

    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        return worksheetContext.getEditor().getSelectedText() != null;
    }

    public WorksheetTaskWrapper<Object> doAction(String string, WorksheetContext worksheetContext) {
        if (!RootNode.getInstance().isOpen()) {
            try {
                RootNode.getInstance().open();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        ReportNavigatorContextMenu.getInstance().reportDialog(RootNode.getInstance().getUserDefined(), null, this.getSql(worksheetContext));
        ReportNavigatorContextMenu.getInstance().saveUserDefined();
        return null;
    }

    private String getSql(WorksheetContext worksheetContext) {
        return worksheetContext.getEditor().getSelectedText();
    }

    public WorksheetAction getActionAt(int n) {
        return this.m_actions.get(n);
    }

    public int getActionsCount() {
        return this.m_actions.size();
    }

    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    public int getPanelCount() {
        return 0;
    }

    static {
        String string = ReportArb.getString("CREATE_REPORT_MENU_ITEM");
        CREATE_REPORT_ACTION = IdeAction.findOrCreate((int)Ide.findOrCreateCmdID((String)CREATE_REPORT), null, (String)StringUtils.stripMnemonic((String)string), (String)"Worksheet", (Integer)StringUtils.getMnemonicKeyCode((String)string), (Icon)ReportArb.getIcon("REPORT_ICON"), null, (boolean)true);
    }
}

