/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.postgresql;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.dbtools.migration.workbench.plugin.postgresql.PostgreSQLConstraintDetails;

public class PostgreSQLConstraintExtractor {
    private String m_createStatement;
    private ArrayList<PostgreSQLConstraintDetails> m_constraints;

    public PostgreSQLConstraintExtractor(String string) {
        this.m_createStatement = string;
        this.m_constraints = new ArrayList();
        this.parseCreateStatement();
    }

    public String[] getConstraintNames() {
        String[] stringArray = new String[this.m_constraints.size()];
        int n = 0;
        for (PostgreSQLConstraintDetails postgreSQLConstraintDetails : this.m_constraints) {
            stringArray[n++] = postgreSQLConstraintDetails.getName();
        }
        return stringArray;
    }

    public PostgreSQLConstraintDetails[] getConstraintDetails() {
        return this.m_constraints.toArray(new PostgreSQLConstraintDetails[this.m_constraints.size()]);
    }

    private void parseCreateStatement() {
        int n;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while ((n3 = this.m_createStatement.indexOf("CONSTRAINT", n2)) != -1) {
            n = this.m_createStatement.indexOf("\n", n3);
            Object object = "";
            if (n != -1) {
                object = this.m_createStatement.substring(n3, n);
                if (((String)object).endsWith(",")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                arrayList.add(object);
            }
            n2 = n;
        }
        n = 0;
        for (String string : arrayList) {
            PostgreSQLConstraintDetails postgreSQLConstraintDetails = new PostgreSQLConstraintDetails();
            ++n;
            int n4 = string.indexOf("CONSTRAINT", 0);
            if (n4 == -1) continue;
            int n5 = string.indexOf("`", n4);
            int n6 = string.indexOf("`", n5 + 1);
            if (n5 != -1 && n6 != -1) {
                String string2 = string.substring(n5 + 1, n6);
                postgreSQLConstraintDetails.setName(string2);
                this.m_constraints.add(postgreSQLConstraintDetails);
            }
            n4 = string.indexOf("(", n4);
            int n7 = string.indexOf(")", n4);
            if (n4 == -1 || n7 == -1) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n4 + 1, n7), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if ((string3 = string3.trim()).startsWith("`")) {
                    string3 = string3.substring(1, string3.length());
                }
                if (string3.endsWith("`")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                postgreSQLConstraintDetails.addFKey(string3);
            }
            int n8 = string.indexOf("REFERENCES", n7);
            if (n8 == -1) continue;
            n8 = string.indexOf("`", n8);
            int n9 = string.indexOf("`", n8 + 1);
            if (n8 != -1 && n9 != -1) {
                String string4 = string.substring(n8, n9);
                if (string4.startsWith("`")) {
                    string4 = string4.substring(1, string4.length());
                }
                if (string4.endsWith("`")) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                postgreSQLConstraintDetails.setReferencedTableName(string4);
            }
            int n10 = string.indexOf("(", n9);
            int n11 = string.indexOf(")", n10);
            if (n10 == -1 || n11 == -1) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(n10 + 1, n11), ",");
            while (stringTokenizer2.hasMoreTokens()) {
                String string5 = stringTokenizer2.nextToken();
                if ((string5 = string5.trim()).startsWith("`")) {
                    string5 = string5.substring(1, string5.length());
                }
                if (string5.endsWith("`")) {
                    string5 = string5.substring(0, string5.length() - 1);
                }
                postgreSQLConstraintDetails.addReferencedKey(string5);
            }
            int n12 = string.indexOf("ON", n11);
            if (n12 == -1) continue;
            String string6 = string.substring(n12, string.length());
            if ((string6 = string6.trim()).endsWith(",")) {
                string6 = string6.substring(0, string6.length() - 1);
            }
            postgreSQLConstraintDetails.setRule(string6);
        }
    }
}

