/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd.custom;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.git.GITUser;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITCommitCustomizer
implements VCSOptionsCustomizer {
    private CommitUI _commitUI;
    private boolean _enableNonStaged;

    public GITCommitCustomizer(boolean enableNonStaged) {
        this._enableNonStaged = enableNonStaged;
    }

    public Component getComponent() {
        if (this._commitUI == null) {
            this._commitUI = new CommitUI(this._enableNonStaged);
        }
        return this._commitUI;
    }

    public void setOptions(Map<?, ?> options) {
        List users;
        if (options.containsKey("commit-not-staged")) {
            Boolean b = (Boolean)options.get("commit-not-staged");
            ((CommitUI)this.getComponent())._btnForce.setSelected(b);
        }
        if (options.containsKey("user-details")) {
            users = (List)options.get("user-details");
            ((CommitUI)this.getComponent()).setAuthor(users);
            ((CommitUI)this.getComponent()).setCommiter(users);
        }
        if (options.containsKey("remember-authors")) {
            users = (List)options.get("remember-authors");
            ((CommitUI)this.getComponent()).setAuthor(users);
        }
        if (options.containsKey("remember-commiters")) {
            users = (List)options.get("remember-commiters");
            ((CommitUI)this.getComponent()).setCommiter(users);
        }
    }

    public Map<?, ?> getOptions() {
        CommitUI ui = (CommitUI)this.getComponent();
        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
        options.put("commit-not-staged", new Boolean(ui._btnForce.isSelected()));
        options.put("commit-author", ui.getAuthor());
        options.put("commit-commiter", ui.getCommiter());
        return options;
    }

    public void validateOptions() throws VCSException {
        Map<?, ?> options = this.getOptions();
        GITUser author = (GITUser)options.get("commit-author");
        if (author == null || author.getName().isEmpty()) {
            throw new VCSException(Resource.get("COMMIT_VALIDATE_TITLE"), Resource.get("COMMIT_AUTHOR_EMPTY"));
        }
        GITUser commiter = (GITUser)options.get("commit-commiter");
        if (commiter == null || commiter.getName().isEmpty()) {
            throw new VCSException(Resource.get("COMMIT_VALIDATE_TITLE"), Resource.get("COMMIT_COMMITER_EMPTY"));
        }
    }

    public Component getInitialFocusComponent() {
        return ((CommitUI)this.getComponent()).getInitialFocusComponent();
    }

    private static class CommitUI
    extends JPanel {
        private JCheckBox _btnForce = new JCheckBox();
        private JLabel _lblAuthor = new JLabel();
        private JComboBox _cmbAuthor = new JComboBox();
        private JLabel _lblCommitter = new JLabel();
        private JComboBox _cmbCommitter = new JComboBox();

        CommitUI(boolean enable) {
            this._btnForce.setEnabled(enable);
            this._cmbAuthor.setEditable(true);
            this._cmbCommitter.setEditable(true);
            this.layoutComponents();
            ResourceUtils.resButton((AbstractButton)this._btnForce, (String)Resource.get("COMMIT_NOT_STAGED"));
            ResourceUtils.resLabel((JLabel)this._lblAuthor, (Component)this._cmbAuthor, (String)Resource.get("COMMIT_AUTHOR"));
            ResourceUtils.resLabel((JLabel)this._lblCommitter, (Component)this._cmbCommitter, (String)Resource.get("COMMIT_COMMITER"));
        }

        private void layoutComponents() {
            Insets lins = new Insets(5, 0, 5, 5);
            Insets rins = new Insets(5, 5, 5, 1);
            Insets cins = new Insets(5, 5, 5, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)this._btnForce, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, lins, 0, 0));
            this.add((Component)this._lblAuthor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, lins, 0, 0));
            this.add((Component)this._cmbAuthor, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, cins, 0, 0));
            this.add((Component)this._lblCommitter, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, cins, 0, 0));
            this.add((Component)this._cmbCommitter, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, rins, 0, 0));
        }

        private Component getInitialFocusComponent() {
            return this._btnForce;
        }

        private void setAuthor(List<GITUser> users) {
            for (int u = 0; u < users.size(); ++u) {
                this._cmbAuthor.addItem(users.get(u));
            }
        }

        private void setCommiter(List<GITUser> users) {
            for (int u = 0; u < users.size(); ++u) {
                this._cmbCommitter.addItem(users.get(u));
            }
        }

        private GITUser getCommiter() {
            Object obj = this._cmbCommitter.getSelectedItem();
            if (obj instanceof GITUser) {
                return (GITUser)obj;
            }
            return GITUser.parseUserEmail((String)obj);
        }

        private GITUser getAuthor() {
            Object obj = this._cmbAuthor.getSelectedItem();
            if (obj instanceof GITUser) {
                return (GITUser)obj;
            }
            return GITUser.parseUserEmail((String)obj);
        }
    }
}

